// file: FindLogic.cs
// brief: text search logic used in AiB Edit
// update: 2008-09-13
//=========================================================
using System;
using System.Text;
using System.Text.RegularExpressions;

namespace Sgry.AiBTools.AiBEdit
{
	using Gui;

	#region NX
	/// <summary>
	/// \NX
	/// </summary>
	public class FindCondition
	{
		/// <summary>p^[</summary>
		public string	Pattern		= "";

		/// <summary>啶ʂ邩ǂ</summary>
		public bool		IgnoreCase	= false;
		
		/// <summary>RpCςݐK\IuWFNg</summary>
		public Regex	Regex		= null;

		/// <summary>
		/// K\gǂ
		/// </summary>
		public bool UseRegex
		{
			get{ return (Regex != null); }
		}
		
		/// <summary>
		/// V FindCondition CX^X𐶐
		/// </summary>
		public FindCondition()
		{}
		
		/// <summary>
		/// Rs[RXgN^
		/// </summary>
		public FindCondition( FindCondition other )
		{
			Pattern = other.Pattern;
			IgnoreCase = other.IgnoreCase;
			Regex = other.Regex;
		}
	}
	#endregion

	/// <summary>
	/// p^[ʁAΏۂȂ
	/// </summary>
	class NotFoundException : ApplicationException
	{}

	/// <summary>
	/// 񌟍sÓINX
	/// </summary>
	internal static class FindLogic
	{
		#region 
		public static bool FindNext( ITextEditor textBox, FindCondition condition, out int matchIndex, out int matchLength )
		{
			// find the pattern
			if( condition.UseRegex )
			{
				return FindNext_Regex( textBox, condition, out matchIndex, out matchLength );
			}
			else
			{
				return FindNext_Normal( textBox, condition, out matchIndex, out matchLength );
			}
		}

		static bool FindNext_Normal( ITextEditor textBox, FindCondition condition, out int matchIndex, out int matchLength )
		{
			int selBegin, selEnd;

			textBox.GetSelection( out selBegin, out selEnd );

			// find the next word position
			matchIndex = Utl.IndexOf( textBox.Text, condition.Pattern, selEnd, condition.IgnoreCase );
			if( matchIndex == -1 )
			{
				matchLength = 0;
				return false;
			}

			matchLength = condition.Pattern.Length;

			return true;
		}
		static bool FindNext_Regex( ITextEditor textBox, FindCondition condition, out int matchIndex, out int matchLength )
		{
			Match matchResult;
			int matchStartIndex;
			int selBegin, selEnd;

			matchIndex = -1;
			matchLength = 0;

			// if search direction was changed, recompile regex
			if( (condition.Regex.Options & RegexOptions.RightToLeft) != 0 )
			{
				// just remove RightToLeft option
				condition.Regex = new Regex( condition.Pattern,
					condition.Regex.Options ^ RegexOptions.RightToLeft );
			}

			// distinguish the index to start matching
			textBox.GetSelection( out selBegin, out selEnd );
			if( selBegin == selEnd )
			{
				// nothing selected.
				matchStartIndex = selBegin;
			}
			else
			{
				// something selected.
				matchStartIndex = selBegin + 1;
				if( textBox.TextLength <= matchStartIndex )
				{
					return false;
				}
			}

			// do matching
			matchResult = condition.Regex.Match( textBox.Text, matchStartIndex );
			if( matchResult.Success )
			{
				// matching succeeded
				matchIndex = matchResult.Index;
				matchLength = matchResult.Length;
				return true;
			}

			// matching failed
			return false;
		}
		#endregion

		#region O
		public static bool FindPrevious( ITextEditor textBox, FindCondition condition, out int matchIndex, out int matchLength )
		{
			if( condition.UseRegex )
			{
				return FindPrevious_Regex( textBox, condition, out matchIndex, out matchLength );
			}
			else
			{
				return FindPrevious_Normal( textBox, condition, out matchIndex, out matchLength );
			}
		}

		static bool FindPrevious_Normal( ITextEditor textBox, FindCondition condition, out int matchIndex, out int matchLength )
		{
			int selBegin, selEnd;

			textBox.GetSelection( out selBegin, out selEnd );

			// find the word position
			matchIndex = Utl.LastIndexOf( textBox.Text, condition.Pattern, selBegin-1, condition.IgnoreCase );
			if( matchIndex == -1 )
			{
				matchLength = 0;
				return false;
			}

			matchLength = condition.Pattern.Length;
			return true;
		}
		static bool FindPrevious_Regex( ITextEditor textBox, FindCondition condition, out int matchIndex, out int matchLength )
		{
			Match matchResult;
			int matchStartIndex;
			int selBegin, selEnd;

			matchIndex = -1;
			matchLength = 0;

			// if find direction was changed, recompile regex
			if( (condition.Regex.Options & RegexOptions.RightToLeft) == 0 )
			{
				// just add RightToLeft option
				condition.Regex
					= new Regex( condition.Pattern, condition.Regex.Options | RegexOptions.RightToLeft );
			}

			// distinguish the index to start matching
			textBox.GetSelection( out selBegin, out selEnd );
			if( selBegin == selEnd )
			{
				// nothing selected. start with SelectionStart
				matchStartIndex = selBegin;
			}
			else
			{
				// something selected. start with SelectionStart-1
				matchStartIndex = selBegin - 1;
				if( matchStartIndex < 0 )
				{
					return false;
				}
			}

			// do matching
			matchResult = condition.Regex.Match( textBox.Text, matchStartIndex );
			if( matchResult.Success )
			{
				// succeeded
				matchIndex = matchResult.Index;
				matchLength = matchResult.Length;
				return true;
			}

			// matching failed
			return false;
		}
		#endregion

		#region Ή
		/// <summary>
		/// w肵JbRɑΉJbR̈ʒu
		/// </summary>
		/// <param name="text">s</param>
		/// <param name="index">̈Ŏw肵ʒuɂJbRƑΉĂJbR܂B</param>
		/// <returns>ΉJbRCfbNX</returns>
		public static int FindMatchedBracket( string text, int index )
		{
			char ch, pairChar;
			bool isOpenBracket;
			int pairIndex;

			if( text.Length <= index )
			{
				return -1; // ܂łȂwCfbNXl
			}

			// LbgʒũJbRJ𔻒
			ch = text[index];
			switch( ch )
			{
				case '(':
					pairChar = ')';
					isOpenBracket = true;
					break;
				case '{':
					pairChar = '}';
					isOpenBracket = true;
					break;
				case '[':
					pairChar = ']';
					isOpenBracket = true;
					break;
				case ')':
					pairChar = '(';
					isOpenBracket = false;
					break;
				case '}':
					pairChar = '{';
					isOpenBracket = false;
					break;
				case ']':
					pairChar = '[';
					isOpenBracket = false;
					break;
				default:
					// JbRłȂ̂ŏI
					Win32.MessageBeep_Notify();
					return -1;
			}

			// ΉJbR
			if( isOpenBracket )
			{
				pairIndex = FindMatchedBracket_Forward( text, index, ch, pairChar );
			}
			else
			{
				pairIndex = FindMatchedBracket_Backward( text, index, ch, pairChar );
			}

			// ȂAֈړ
			if( pairIndex == -1 )
			{
				return -1;
			}

			return pairIndex;
		}

		static int FindMatchedBracket_Forward( string text, int index, char bracket, char pairBracket )
		{
			int depth = 0;

			// ֈꕶĂ
			for( int i=index; i<text.Length; i++ )
			{
				if( text[i] == bracket )
				{
					depth++;
				}
				else if( text[i] == pairBracket )
				{
					depth--;
					if( depth == 0 )
					{
						return i;
					}
				}
			}

			// Ȃ
			return -1;
		}

		static int FindMatchedBracket_Backward( string text, int index, char bracket, char pairBracket )
		{
			int depth = 0;

			// ֈꕶĂ
			for( int i=index; 0<=i; i-- )
			{
				if( text[i] == bracket )
				{
					depth++;
				}
				else if( text[i] == pairBracket )
				{
					depth--;
					if( depth == 0 )
					{
						return i;
					}
				}
			}

			// Ȃ
			return -1;
		}
		#endregion

		#region 
		class Utl
		{
			/// <summary>
			/// ᑬȑOWbN
			/// </summary>
			public static int IndexOf( string text, string word, int start, bool ignoreCase )
			{
				try
				{
					int i, j;

					for( i=start; i<text.Length; i++ )
					{
						// ̐擪ꕶwPƏƍ
						for( j=0; j<word.Length; j++ )
						{
							if( text[i+j] == word[j] )
							{
								continue; // match next char
							}
							else if( ignoreCase && (Char.ToLower(text[i+j]) == Char.ToLower(word[j])) )
							{
								continue; // match next char
							}

							// ̓̕p^[vȂ
							break;
						}

						// ƍȂÃCfbNXԂ
						if( j == word.Length )
						{
							return i;
						}
					}
				}
				catch( IndexOutOfRangeException )
				{}

				return -1;
			}
			/// <summary>
			/// ᑬȌWbN
			/// </summary>
			public static int LastIndexOf( string text, string word, int start, bool ignoreCase )
			{
				try
				{
					int i, j;

					for( i=start; 0<=i; i-- )
					{
						// ̖ꕶwPƏƍ
						for( j=0; j<word.Length; j++ )
						{
							if( text[i+j] == word[j] )
							{
								continue; // match next char
							}
							else if( ignoreCase && (Char.ToLower(text[i+j]) == Char.ToLower(word[j])) )
							{
								continue; // match next char
							}

							// ̓̕p^[vȂ
							break;
						}

						// ƍȂÃCfbNXԂ
						if( j == word.Length )
						{
							return i;
						}
					}
				}
				catch( IndexOutOfRangeException )
				{}

				return -1;
			}
		}
		#endregion
	}
}
