// file: FindDialog.cs
// brief: a dialog window for "find" command.
// update: 2008-09-23
//=========================================================
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using Debug = System.Diagnostics.Debug;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	/// <summary>
	/// 񌟍_CAO
	/// </summary>
	class FindDialog : AiBDialogBase
	{
		FindCondition	_FindCondition;
		bool			_FindBackward;

		public FindCondition FindCondition
		{
			get{ return _FindCondition; }
		}

		/// <summary>
		/// AO֌čsǂ擾܂
		/// </summary>
		public bool FindBackward
		{
			get{ return _FindBackward; }
		}

		#region Init / Dispose
		/// <summary>
		/// 񌟍tH[
		/// </summary>
		public FindDialog( ref FindCondition condition )
		{
			InitializeComponent();
			LocalizeComponents();
			AutoScaleMode = AutoScaleMode.Font;
			Font = SystemInformation.MenuFont;
			_Button_Cancel.DialogResult = DialogResult.Cancel;
			FormBorderStyle = FormBorderStyle.FixedDialog;

			_FindCondition = condition;
		}

		void Form_Load( object sender, EventArgs e )
		{
			_Edit_SearchPattern.Text = _FindCondition.Pattern;
			_Check_IgnoreCase.Checked = _FindCondition.IgnoreCase;
			_Check_UseRegex.Checked = (_FindCondition.Regex != null);
		}
		#endregion // Init / Dispose

		#region {^ꂽ̓
		void _Button_Next_Click( object sender, EventArgs e )
		{
			bool ok;
			_FindBackward = false;
			ok = ValidateAndSetFindCondition();
			if( ok )
			{
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		void _Button_Cancel_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		void _Button_Prev_Click( object sender, EventArgs e )
		{
			bool ok;
			_FindBackward = true;
			ok = ValidateAndSetFindCondition();
			if( ok )
			{
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		bool ValidateAndSetFindCondition()
		{
			// generic options
			_FindCondition.Pattern = _Edit_SearchPattern.Text;
			_FindCondition.IgnoreCase = _Check_IgnoreCase.Checked;
			
			// options for regular expression
			if( _Check_UseRegex.Checked )
			{
				try
				{
					// apply option
					RegexOptions option = RegexOptions.None;
					if( _FindCondition.IgnoreCase )
					{
						option |= RegexOptions.IgnoreCase;
					}

					// compile 
					_FindCondition.Regex = new Regex( _FindCondition.Pattern, option );
				}
				catch( ArgumentException ex )
				{
					string format = AppLogic.Localizer.TryGetString(
						"FindDialog.Msg_InvalidRegex", "Invalid reguler expression. {0}" );
					NbsMessageBox.Show( this, String.Format(format,ex.Message) );
					return false;
				}
			}
			else
			{
				_FindCondition.Regex = null;
			}

			return true;
		}
		#endregion // {^ꂽ̓

		#region UI Component Initialization
		/// <summary>
		/// [JCY
		/// </summary>
		void LocalizeComponents()
		{
			// localize controls
			foreach( Control ctrl in Controls )
			{
				if( ctrl.HasChildren ) // for group control
				{
					foreach( Control ctrl2 in ctrl.Controls )
					{
						AppLogic.Localizer.TryGetString( "FindDialog." + ctrl2.Name + ".Text", ctrl2 );
					}
				}
				AppLogic.Localizer.TryGetString( "FindDialog." + ctrl.Name + ".Text", ctrl );
			}

			// localize form's text
			AppLogic.Localizer.TryGetString( "FindDialog.Text", this );
		}

		/// <summary>
		/// UI i܂B
		/// </summary>
		void InitializeComponent()
		{
			this._Edit_SearchPattern = new System.Windows.Forms.TextBox();
			this._Button_Prev = new System.Windows.Forms.Button();
			this._Button_Next = new System.Windows.Forms.Button();
			this._Group_Options = new System.Windows.Forms.GroupBox();
			this._Check_UseRegex = new System.Windows.Forms.CheckBox();
			this._Check_IgnoreCase = new System.Windows.Forms.CheckBox();
			this._Button_Cancel = new System.Windows.Forms.Button();
			this._Label_SearchPattern = new System.Windows.Forms.Label();
			this._Group_Options.SuspendLayout();
			this.SuspendLayout();
			// 
			// _Edit_SearchPattern
			// 
			this._Edit_SearchPattern.Location = new System.Drawing.Point( 144, 12 );
			this._Edit_SearchPattern.Name = "_Edit_SearchPattern";
			this._Edit_SearchPattern.Size = new System.Drawing.Size( 260, 24 );
			this._Edit_SearchPattern.TabIndex = 1;
			// 
			// _Button_Prev
			// 
			this._Button_Prev.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._Button_Prev.Location = new System.Drawing.Point( 420, 42 );
			this._Button_Prev.Name = "_Button_Prev";
			this._Button_Prev.Size = new System.Drawing.Size( 104, 24 );
			this._Button_Prev.TabIndex = 4;
			this._Button_Prev.Text = "&Previous";
			this._Button_Prev.Click += new System.EventHandler( this._Button_Prev_Click );
			// 
			// _Button_Next
			// 
			this._Button_Next.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._Button_Next.Location = new System.Drawing.Point( 420, 12 );
			this._Button_Next.Name = "_Button_Next";
			this._Button_Next.Size = new System.Drawing.Size( 104, 24 );
			this._Button_Next.TabIndex = 3;
			this._Button_Next.Text = "&Next";
			this._Button_Next.Click += new System.EventHandler( this._Button_Next_Click );
			// 
			// _Group_Options
			// 
			this._Group_Options.Controls.Add( this._Check_UseRegex );
			this._Group_Options.Controls.Add( this._Check_IgnoreCase );
			this._Group_Options.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._Group_Options.Location = new System.Drawing.Point( 16, 37 );
			this._Group_Options.Name = "_Group_Options";
			this._Group_Options.Size = new System.Drawing.Size( 390, 70 );
			this._Group_Options.TabIndex = 2;
			this._Group_Options.TabStop = false;
			this._Group_Options.Text = "Options";
			// 
			// _Check_UseRegex
			// 
			this._Check_UseRegex.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._Check_UseRegex.Location = new System.Drawing.Point( 16, 43 );
			this._Check_UseRegex.Name = "_Check_UseRegex";
			this._Check_UseRegex.Size = new System.Drawing.Size( 360, 17 );
			this._Check_UseRegex.TabIndex = 1;
			this._Check_UseRegex.Text = "Use &regular expression";
			// 
			// _Check_IgnoreCase
			// 
			this._Check_IgnoreCase.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._Check_IgnoreCase.Location = new System.Drawing.Point( 16, 20 );
			this._Check_IgnoreCase.Name = "_Check_IgnoreCase";
			this._Check_IgnoreCase.Size = new System.Drawing.Size( 360, 17 );
			this._Check_IgnoreCase.TabIndex = 0;
			this._Check_IgnoreCase.Text = "Ignore &case";
			// 
			// _Button_Cancel
			// 
			this._Button_Cancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this._Button_Cancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this._Button_Cancel.Location = new System.Drawing.Point( 420, 82 );
			this._Button_Cancel.Name = "_Button_Cancel";
			this._Button_Cancel.Size = new System.Drawing.Size( 104, 24 );
			this._Button_Cancel.TabIndex = 5;
			this._Button_Cancel.Text = "Cancel";
			this._Button_Cancel.Click += new System.EventHandler( this._Button_Cancel_Click );
			// 
			// _Label_SearchPattern
			// 
			this._Label_SearchPattern.Location = new System.Drawing.Point( 16, 15 );
			this._Label_SearchPattern.Name = "_Label_SearchPattern";
			this._Label_SearchPattern.Size = new System.Drawing.Size( 120, 17 );
			this._Label_SearchPattern.TabIndex = 0;
			this._Label_SearchPattern.Text = "&Search pattern";
			this._Label_SearchPattern.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// FindDialog
			// 
			this.AcceptButton = this._Button_Next;
			this.CancelButton = this._Button_Cancel;
			this.ClientSize = new System.Drawing.Size( 543, 120 );
			this.Controls.Add( this._Button_Cancel );
			this.Controls.Add( this._Group_Options );
			this.Controls.Add( this._Button_Next );
			this.Controls.Add( this._Button_Prev );
			this.Controls.Add( this._Label_SearchPattern );
			this.Controls.Add( this._Edit_SearchPattern );
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "FindDialog";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Find";
			this.Load += new System.EventHandler( this.Form_Load );
			this._Group_Options.ResumeLayout( false );
			this.ResumeLayout( false );
			this.PerformLayout();

		}
		#endregion

		#region UI Components
		TextBox		_Edit_SearchPattern		= new TextBox();
		Button		_Button_Prev			= new Button();
		Button		_Button_Next			= new Button();
		GroupBox	_Group_Options			= new GroupBox();
		CheckBox	_Check_IgnoreCase		= new CheckBox();
		Button		_Button_Cancel			= new Button();
		Label		_Label_SearchPattern	= new Label();
		CheckBox	_Check_UseRegex			= new CheckBox();

		CheckBoxReader	_CheckBoxReader	= new CheckBoxReader();
		TextBoxReader	_TextBoxReader	= new TextBoxReader();
		ControlBrailler	_ControlBrailler = new ControlBrailler();
		TextBoxBrailler	_TextBoxBrailler = new TextBoxBrailler();
		#endregion

		/// <summary>
		/// _CAOŎgp_\NCAg܂B
		/// </summary>
		protected override void InstallBraillers()
		{
			_ControlBrailler.Init();
			_ControlBrailler.Add( _Button_Next );
			_ControlBrailler.Add( _Button_Prev );
			_ControlBrailler.Add( _Button_Cancel );
			_ControlBrailler.Add( _Check_IgnoreCase );
			_ControlBrailler.Add( _Check_UseRegex );

			_TextBoxBrailler.Init();
			_TextBoxBrailler.Add( _Edit_SearchPattern );
		}

		/// <summary>
		/// _CAOŎgp_\NCAg̃\[X܂B
		/// </summary>
		protected override void UninstallBraillers()
		{
			_ControlBrailler.Dispose();
			_TextBoxBrailler.Dispose();
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_܂B
		/// </summary>
		protected override void InstallReaders()
		{
			_CheckBoxReader.Add( _Check_IgnoreCase );
			_CheckBoxReader.Add( _Check_UseRegex );
			_TextBoxReader.Add( _Edit_SearchPattern );
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_̃\[X܂B
		/// </summary>
		protected override void UninstallReaders()
		{
			_CheckBoxReader.Dispose();
			_TextBoxReader.Dispose();
		}
	}
}
