// file: DocumentListDialog.cs
// brief: dialog which lists up all documents opened
// update: 2008-12-20
//=========================================================
using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	/// <summary>
	/// ވꗗ_CAO
	/// </summary>
	class DocumentListDialog : AiBDialogBase
	{
		#region Fields
		ListViewItem _InitSelectItem = null;
		Document _SelectedDocument;
		#endregion

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		public DocumentListDialog( List<Document> documents, Document activeDoc )
		{
			InitializeComponents();

			// add document names to the list
			foreach( Document doc in documents )
			{
				ListViewItem item = new ListViewItem();

				// setup item
				item.Text = doc.ToString();
				item.Tag = doc;

				// remember this if it's the init-select document
				if( doc == activeDoc )
					_InitSelectItem = item;

				_ListView.Items.Add( item );
			}

			_ColumnHeader.Width = -2;
			_ListView.ListViewItemSorter = new SimplestListViewItemComparer();
			_ListView.Sort();
		}

		/// <summary>
		/// tH[̏I̓B
		/// IڂIB
		/// </summary>
		void Form_Load( object sender, EventArgs e )
		{
			_InitSelectItem.Focused = true;
			_InitSelectItem.Selected = true;
		}

		void Form_Activated( object sender, EventArgs e )
		{
			_ListViewBrailler.UpdateDisplay();
		}
		#endregion

		#region Interface
		/// <summary>
		/// [UI
		/// </summary>
		public Document SelectedDocument
		{
			get{ return _SelectedDocument; }
		}
		#endregion

		#region List view control
		void ListView_DoubleClick( object sender, EventArgs e )
		{
			Decide();
		}

		void ListView_KeyDown( object sender, KeyEventArgs e )
		{
			if( e.KeyCode == Keys.Enter )
			{
				Decide();
			}
		}

		void Decide()
		{
			if( _ListView.SelectedItems.Count == 0 )
			{
				// may be un-jumpable symbol.
				// in C++ source, there can be no class def/decl but may exist member functions.
				// in such case, dummy node of the owner class of the function would be generated.
				// such class node has no proper location to jump to.
				Win32.MessageBeep_Notify();
				return;
			}

			_SelectedDocument = (Document)_ListView.SelectedItems[0].Tag;

			this.DialogResult = DialogResult.OK;
			this.Close();
		}
		#endregion

		#region UI behavior customization
		/// <summary>
		/// I[i[EBhE̒ɓKȃTCYŃ[_\
		/// </summary>
		public new DialogResult ShowDialog( IWin32Window owner )
		{
			// ҂̌lIϓ_KƎvTCY
			Width = 640;
			if( SystemInformation.WorkingArea.Height < 600 )
				Height = SystemInformation.WorkingArea.Height;
			else
				Height = 600;

			// _CAO\
			return base.ShowDialog( owner );
		}

		/// <summary>
		/// Ctrl+W  Escape ŕ悤
		/// </summary>
		protected override bool ProcessCmdKey( ref Message msg, Keys keyData )
		{
			const int WM_KEYDOWN = 0x100;

			// close window when ctrl+w pressed
			if( msg.Msg == WM_KEYDOWN )
			{
				if( keyData == (Keys.Control | Keys.W) ) // Ctrl + W
					this.Close();
				if( keyData == (Keys.Escape) ) // Escape
					this.Close();
			}

			return base.ProcessCmdKey( ref msg, keyData );
		}
		#endregion

		#region Utilities
		class SimplestListViewItemComparer : IComparer
		{
			public int Compare( object x, object y )
			{
				return String.Compare( ((ListViewItem)x).SubItems[0].Text, ((ListViewItem)y).SubItems[0].Text );
			}
		}
		#endregion

		#region UI Components
		ColumnHeader _ColumnHeader = new ColumnHeader();
		ListView _ListView = new AiBListView();
		ListViewBrailler _ListViewBrailler = new ListViewBrailler();
		#endregion

		#region UI Component Initialization
		/// <summary>
		/// _CAOŎgp_\NCAg܂B
		/// </summary>
		protected override void InstallBraillers()
		{
			_ListViewBrailler.Init();
			_ListViewBrailler.Add( _ListView );
		}

		/// <summary>
		/// _CAOŎgp_\NCAg̃\[X܂B
		/// </summary>
		protected override void UninstallBraillers()
		{
			_ListViewBrailler.Dispose();
		}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_܂B
		/// </summary>
		protected override void InstallReaders()
		{}

		/// <summary>
		/// _CAÕRg[ǂݏグXN[[_̃\[X܂B
		/// </summary>
		protected override void UninstallReaders()
		{}

		/// <summary>
		/// [JCY
		/// </summary>
		void LocalizeComponents()
		{
			AppLogic.Localizer.TryGetString( "DocumentListDialog.Text", this );
		}

		void InitializeComponents()
		{
			// initialize form itself
			Text = "Window list";
			FormBorderStyle = FormBorderStyle.SizableToolWindow;
			StartPosition = FormStartPosition.CenterParent;
			Font = SystemInformation.MenuFont;
			Activated += Form_Activated;
			Load += Form_Load;

			// initialize list view
			_ListView.Dock = DockStyle.Fill;
			_ListView.View = View.Details;
			_ColumnHeader.Text = "Title";
			_ListView.Columns.Add( _ColumnHeader );
			_ListView.GridLines = true;
			_ListView.FullRowSelect = true;
			_ListView.HeaderStyle = ColumnHeaderStyle.None;
			_ListView.KeyDown += new KeyEventHandler( ListView_KeyDown );
			_ListView.DoubleClick += new EventHandler( ListView_DoubleClick );
			Controls.Add( _ListView );
		}
		#endregion
	}
}
