// file : CsharpFileType.cs
// brief : File type class for C#
// update : 2007-08-25
//=========================================================
using System;
using System.Text;
using System.Windows.Forms;
using Path = System.IO.Path;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// C# ̃\[Xt@Ct@C^Cv
	/// </summary>
	class CsharpFileType : IFileType
	{
		/// <summary>
		/// t@Cޖ
		/// </summary>
		public string Name
		{
			get{ return "C#"; }
		}

		/// <summary>
		/// wpX̃t@C邩
		/// </summary>
		/// <param name="filePath">肷t@C̃pX</param>
		/// <returns>ꍇtrue</returns>
		public bool CanHandleFile( string filePath )
		{
			const bool IGNORE_CASE = true;
			string[] exts = new string[]{ ".cs" };
			string fileExt;
			
			// gq C# ŎĝȂ爵
			fileExt = Path.GetExtension( filePath );
			foreach( string ext in exts )
			{
				if( String.Compare(fileExt, ext, IGNORE_CASE) == 0 )
				{
					return true;
				}
			}

			return false;
		}

		/// <summary>
		/// ̃AEgC\
		/// </summary>
		/// <returns>[UIV{CfbNX</returns>
		public int ShowOutline( Form owner, string docContent, int caretIndex )
		{
			DialogResult result;
			Outliner parser;

			using( OutlineDialog dialog = new OutlineDialog() )
			{
				// setup dialog
				dialog.Size = owner.Size;
				dialog.Location = owner.Location;
				
				// parse
				parser = new CppOutliner( dialog, docContent, caretIndex );
				parser.Parse();

				// show dialog
				result = dialog.ShowDialog( owner );
				if( result != DialogResult.OK )
				{
					return -1;
				}

				// return selected symbol
				return dialog.SelectedSymbolIndex;
			}
		}

		/// <summary>
		/// ҏWΏۂRpC
		/// </summary>
		/// <returns>RpC</returns>
		public CompileResult Compile( Document doc )
		{
			return CompileResult.FailedToExecute;
		}

		/// <summary>
		/// rhR}hs
		/// </summary>
		/// <returns>RpC</returns>
		public CompileResult Build( Document doc )
		{
			return CompileResult.FailedToExecute;
		}
	}
}
