// file: CppOutliner.cs
// brief: Outline parser for C family (C, C++, C#, Java)
// update: 2008-09-13
//=========================================================
using System;
using System.Text;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// C np̃AEgC͊
	/// </summary>
	class CppOutliner : Outliner
	{
		#region Constants
		static readonly char[] Brackets	= new char[] { '{', '}' };
		static readonly char[] LogicalLineEndChar = new char[] { '{', '}', ';' };
		#endregion

		/// <summary>
		/// CX^X𐶐
		/// </summary>
		/// <param name="dialog">V{\AEgC_CAO</param>
		/// <param name="source">͂镶</param>
		/// <param name="caretIndex">݂̃Lbgʒu</param>
		public CppOutliner( OutlineDialog dialog, string source, int caretIndex )
			: base( dialog, source, caretIndex )
		{}

		/// <summary>
		/// V{𒊏oăc[Rg[ɕ\
		/// </summary>
		public override void Parse()
		{
			// parse source code
			try
			{
				Parse( _Dialog.TreeView, Strip(_Source), _CaretIndex );
			}
#			if DEBUG
			catch( Exception ex )
			{
				throw ex;
			}
#			else
			catch
			{}
#			endif

			// if no identifier found, display dummy node with message
			if( _Dialog.TreeView.Nodes.Count == 0 )
			{
				_DummyNode.Tag = _CaretIndex;
				_Dialog.TreeView.Nodes.Add( _DummyNode );
			}
		}

		#region ̓WbN
		static void Parse( TreeView treeView, string source, int caretIndex )
		{
			int pos = 0;
			TreeNode currentParent = null;
			TreeNode initSelNode = null;

			// parse
			pos = FindNextBracketPos( source, pos );
			while( pos != -1 )
			{
				if( source[pos] == '{' )
				{
					// oϐ`̔z񏉊q̊JJbRȂ疳
					if( IsArrayInitializerBegin(source, pos) )
					{
						pos = FindPairedCloseBracket( source, pos );
						if( pos == -1 )
						{
							break;
						}
						pos++;
					}
					else
					{
						Parse_OnOpenBracket( treeView, ref initSelNode, source, caretIndex, ref pos, ref currentParent );
					}
				}
				else if( source[pos] == '}' )
				{
					if( currentParent != null )
						currentParent = currentParent.Parent;
				}
				if( pos == -1 )
				{
					break; // some error occured in inner process
				}

				// find next
				pos = FindNextBracketPos( source, pos+1 );
			}

			// select initial selection node
			if( initSelNode != null )
			{
				Win32.TreeView_SelectItem( treeView.Handle, initSelNode.Handle );
			}
		}

		/// <summary>
		/// Find next position where a symbol was expected to exist around.
		/// </summary>
		static int FindNextBracketPos( string source, int startPos )
		{
			int foundPos = startPos;

			// find keyword near the next identifier
			foundPos = source.IndexOfAny( Brackets, foundPos );
			while( foundPos != -1 && foundPos < source.Length )
			{
				if( source[foundPos] == '{'
					|| source[foundPos] == '}' )
				{
					return foundPos; // found
				}

				// find keyword near the next identifier
				foundPos = source.IndexOfAny( Brackets, foundPos+1 );
			}

			return -1; // no more IDs
		}

		static void Parse_OnOpenBracket( TreeView treeView, ref TreeNode initSelNode, string source, int caretIndex, ref int pos, ref TreeNode currentParent )
		{
			bool succeeded;

			// class?
			succeeded = TryParseContainerSymbol( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos, "class" );
			if( succeeded )  return;

			// interface?
			succeeded = TryParseContainerSymbol( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos, "interface" );
			if( succeeded )  return;

			// namespace?
			succeeded = TryParseContainerSymbol( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos, "namespace" );
			if( succeeded )  return;

			// struct?
			succeeded = TryParseContainerSymbol( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos, "struct" );
			if( succeeded )  return;

			// enum?
			succeeded = TryParseContainerSymbol( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos, "enum" );
			if( succeeded )  return;

			// union?
			succeeded = TryParseContainerSymbol( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos, "union" );
			if( succeeded )  return;

			// function / method?
			succeeded = TryParseFunctionSymbol( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos );
			if( succeeded )  return;

			// property?
			succeeded = TryParseProperty( treeView, ref currentParent, ref initSelNode, source, caretIndex, ref pos );
			if( succeeded )  return;
		}

		static bool TryParseContainerSymbol( TreeView treeView, ref TreeNode currentParent, ref TreeNode initSelNode,
				string source, int caretIndex,
				ref int pos, string symbolType )
		{
			int idKeyPos, idPos;
			string idName;

			idKeyPos = FindWordInLogicalLine( source, pos-1, symbolType );
			if( idKeyPos == -1 )
			{
				return false;
			}

			// extract name and add node
			idName = ExtractSymbolNameFromLine( source.Substring(idKeyPos, pos-idKeyPos), symbolType );
			if( idName == null )
			{
				return false;
			}
			idPos = Utl.NextWordPos( source, idKeyPos );

			// insert tree node
			TreeNode node = new TreeNode( /*symbolType[0] + " " + */idName );
			node.Tag = idPos;
			if( currentParent == null )
			{
				treeView.Nodes.Add( node );
			}
			else
			{
				currentParent.Nodes.Add( node );
			}

			// ̃m[hI邩
			if( Utl.CurrentLineHeadPos(source, idPos) <= caretIndex )
				initSelNode = node;

			// ̃m[hJgm[h
			currentParent = node;

			return true;
		}

		static bool TryParseFunctionSymbol( TreeView treeView, ref TreeNode currentParent, ref TreeNode initSelNode,
				string source, int caretIndex, ref int pos )
		{
			int		idKeyPos, idPos, idNameEndPos, idNameBeginPos;
			string	idName;
			TreeNode node;
			int		scopeOpPos;

			idKeyPos = FindCharInLogicalLine( source, pos-1, '(' );
			if( idKeyPos == -1 )
			{
				return false;
			}

			// extract function name
			idNameEndPos = Utl.PrevNonWhiteSpacePos( source, idKeyPos-1 ) + 1;
			idNameBeginPos = Utl.PrevWhiteSpacePos( source, idNameEndPos-1 ) + 1;
			if( idNameBeginPos <= 0 || idNameBeginPos <= 0 )
			{
				return false;
			}
			idName = source.Substring( idNameBeginPos, idNameEndPos - idNameBeginPos );
			idPos = idNameEndPos - idName.Length + 1;

			// is this a member function?
			scopeOpPos = idName.IndexOf( "::" );
			if( scopeOpPos != -1 )
			{
				// --- add node as a child of proper class ---
				string className = idName.Substring( 0, scopeOpPos );
				
				// find the class
				TreeNode classNode = Utl.FindNodeByNameIn( treeView.Nodes, /*"c " + */className );
				if( classNode == null )
				{
					// the class was not added yet. then add.
					classNode = new TreeNode( /*"c " + */className );
					if( currentParent == null )
						treeView.Nodes.Add( classNode );
					else
						currentParent.Nodes.Add( classNode );
				}

				// add node
				node = new TreeNode( /*"m " + */idName.Substring(scopeOpPos+2) ); // 2=="::".Length
				node.Tag = idPos;
				classNode.Nodes.Add( node );
			}
			else
			{
				// --- add node to current node ---
				node = new TreeNode();
				node.Tag = idPos;
				if( currentParent == null )
				{
					node.Text = /*"f " + */idName;
					treeView.Nodes.Add( node );
				}
				else
				{
					// if parent is class or interface, this is a method
					/*string prefix = "f ";

					char pType = currentParent.Text[0];
					if( pType == 'c' || pType == 'i' ) // class or interface
						prefix = "m ";*/

					node.Text = /*prefix + */idName;
					currentParent.Nodes.Add( node );
				}
			}

			// \bh̓eXLbv
			pos = FindPairedCloseBracket( source, pos );

			// ̃m[hI邩
			if( Utl.CurrentLineHeadPos(source, idPos) <= caretIndex )
				initSelNode = node;

			return true;
		}

		/// <summary>
		/// wʒuɂJʂvpeB̊JnB
		/// </summary>
		static bool TryParseProperty( TreeView treeView,
				ref TreeNode currentParent, ref TreeNode initSelNode,
				string source, int caretIndex, ref int pos )
		{
			int idPos, nextTokenPos;
			string idName, nextToken;

			if( pos <= 0 || source.Length <= pos+1 )
			{
				// 㑱̂ŃvpeBł͂Ȃ 
				return false;
			}

			// ̃g[Nʒu擾
			nextTokenPos = Utl.NextNonWhiteSpacePos( source, pos+1 );
			if( nextTokenPos == -1 )
			{
				// 㑱ׂċ󔒂
				return false;
			}

			// g[N get/set mF
			nextToken = Utl.WordAt( source, nextTokenPos );
			if( nextToken != "get"
				&& nextToken != "set" )
			{
				return false;
			}

			// vpeBBvpeB擾
			int idEndPos;
			idEndPos = Utl.PrevNonWhiteSpacePos( source, pos-1 );
			if( idEndPos == -1 )
			{
				return false;
			}
			idName = Utl.WordAt( source, idEndPos );
			idPos = idEndPos - idName.Length;

			// ̃vpeB̏I܂ŉ͈ʒui߂
			pos = FindPairedCloseBracket( source, pos );
			if( pos == -1 )
			{
				// JbRĂȂȂt@CŕꂽƂip[XIj
				pos = source.Length - 1;
			}
			pos++;

			// insert tree node
			TreeNode node = new TreeNode( /*"p " + */idName );
			node.Tag = idPos;
			if( currentParent == null )
			{
				treeView.Nodes.Add( node );
			}
			else
			{
				currentParent.Nodes.Add( node );
			}

			// ̃m[hI邩
			if( Utl.CurrentLineHeadPos(source, idPos) <= caretIndex )
				initSelNode = node;

			return true;
		}

		/// <summary>
		/// wʒu܂܂_s̍sPB
		/// </summary>
		static int FindWordInLogicalLine( string source, int startPos, string word )
		{
			int logicalLineHeadPos;
			int wordBeginPos;
			string foundWord;

			logicalLineHeadPos = source.LastIndexOfAny( LogicalLineEndChar, startPos ) + 1;
			//lsvif( logicalLineHeadPos == 0 )

			// get the word position
			wordBeginPos = source.IndexOf( word, logicalLineHeadPos, startPos - logicalLineHeadPos );
			if( wordBeginPos <= 0 || source.Length <= wordBeginPos )
				return -1; // no such word

			foundWord = Utl.WordAt( source, wordBeginPos );
			if( foundWord != word )
				return -1;

			return wordBeginPos;
		}

		/// <summary>
		/// wʒu܂܂_s̍s當B
		/// </summary>
		static int FindCharInLogicalLine( string source, int startPos, char ch )
		{
			int logicalLineHeadPos;
			int wordBeginPos;

			if( startPos <= 0 )
			{
				logicalLineHeadPos = 0;
			}
			else
			{
				logicalLineHeadPos = source.LastIndexOfAny( LogicalLineEndChar, startPos-1 ) + 1;
				//lsvif( logicalLineHeadPos == 0 )
			}

			// get the word position
			wordBeginPos = source.IndexOf( ch, logicalLineHeadPos, startPos - logicalLineHeadPos );
			if( wordBeginPos <= 0 || source.Length <= wordBeginPos )
				return -1; // no such word

			return wordBeginPos;
		}

		/// <summary>
		/// \[ẌsV{𒊏oB
		/// wL[[h̒PĕԂB
		/// </summary>
		/// <returns>snull</returns>
		static string ExtractSymbolNameFromLine( string line, string key )
		{
			int pos;

			pos = line.IndexOf( key );
			if( pos == -1 )
			{
				return null;
			}

			int classNamePos = Utl.NextWordPos( line, pos );
			if( classNamePos == -1 )
			{
				return null;
			}

			return Utl.WordAt( line, classNamePos );
		}

		/// <summary>
		/// wʒuɂJʂ̑΂ƂȂʂ
		/// </summary>
		static int FindPairedCloseBracket( string source, int openBracketPos )
		{
			int depth = 1;
			int pos = openBracketPos;

			try
			{
				// Jʂ̈ʒu珇ɕʂT
				while( 0 < depth && 0 < pos && pos + 1 < source.Length )
				{
					// ̒ʂT
					pos = source.IndexOfAny( Brackets, pos + 1 );
					if( source[pos] == '{' )
					{
						depth++;
					}
					else
					{
						depth--;
					}
				}

				return pos;
			}
			catch( IndexOutOfRangeException )
			{
				return -1;
			}
		}

		/// <summary>
		/// wʒuɂJʂz񏉊q̊JnB
		/// 蔲œ_s=邩Ŕ肵ĂB
		/// </summary>
		static bool IsArrayInitializerBegin( string source, int openBracketPos )
		{
			int equalPos;

			equalPos = FindCharInLogicalLine( source, openBracketPos, '=' );
			if( equalPos != -1 )
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		#endregion

		#region Rg̏WbN
		/// <summary>
		/// AEgC͂ŎזɂȂRg菜
		/// </summary>
		/// <param name="src">Rg菜\[X</param>
		/// <returns>Rg菜ꂽ\[X</returns>
		public static string Strip( string src )
		{
			StringBuilder buffer = new StringBuilder( src.Length );

			for( int i=0; i<src.Length; i++ )
			{
				// string literal begin?
				if( src[i] == '\'' )
				{
					// string literal found. replace it into whitespaces
					i = Utl.EmptyToPattern( src, i, "\'", ref buffer );
				}
				// charcter literal begin?
				else if( src[i] == '\"' )
				{
					i = Utl.EmptyToPattern( src, i, "\"", ref buffer );
				}
				// attribute begin?
				else if( src[i] == '[' )
				{
					i = Utl.EmptyToPattern( src, i, "]", ref buffer );
				}
				// preprocessor-macro begin?
				else if( src[i] == '#' )
				{
					// make this line empty
					int nextLineHeadPos = Utl.NextLineHeadPos( src, i+1 );
					if( nextLineHeadPos == -1 )
					{
						break; // fatal error
					}
					for( int j=0; j<nextLineHeadPos - i - 1; j++ )
						buffer.Append( ' ' );
					i = nextLineHeadPos - 1; // -1 for i++ at next loop begin
				}
				// comment begin?
				else if( src[i] == '/' )
				{
					if( src[i+1] == '/' )
					{
						// one-line comment found
						int nextLineHeadPos = Utl.NextLineHeadPos( src, i+1 );
						if( nextLineHeadPos == -1 )
						{
							break; // fatal error
						}
						for( int j=0; j<nextLineHeadPos - i - 1; j++ )
							buffer.Append( ' ' );
						i = nextLineHeadPos - 1; // -1 for i++ at next loop begin
					}
					else if( src[i+1] == '*' )
					{
						// block comment found
						i = Utl.EmptyToPattern( src, i, "*/", ref buffer );
					}
				}

				// add this char to comment-stripped buffer
				buffer.Append( src[i] );
			}

			return buffer.ToString();
		}
		#endregion
	}
}
