// file: AzukiOptionDialog.cs
// brief: dialog window for Azuki specific options
// update: 2008-11-20
//=========================================================
using System;
using System.Diagnostics;
using System.Windows.Forms;
using CancelEventArgs = System.ComponentModel.CancelEventArgs;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	/// <summary>
	/// Azuki ŗL̃IvVݒ肷_CAOB
	/// </summary>
	class AzukiOptionDialog : AiBDialogBase
	{
		string _Msg_TabWidthMustBeNumeber;

		#region Init / Dispose
		public AzukiOptionDialog()
		{
			InitializeComponent();
			LocalizeComponent();
			AutoScaleMode = AutoScaleMode.Font;
			Font = SystemInformation.MenuFont;
			AcceptButton = _Button_Ok;
			CancelButton = _Button_Cancel;
			Activated += Form_Activated;
			_Edit_TabWidth.Validating += delegate( object sender, CancelEventArgs e ) {
				int n;
				if( Int32.TryParse(_Edit_TabWidth.Text, out n) == false )
				{
					NbsMessageBox.Show( _Msg_TabWidthMustBeNumeber );
					e.Cancel = true;
				}
			};
			Shown += delegate {
				_Combo_SpeaksLineFromCaret.Select();
			};

			_Combo_SpeaksLineFromCaret.SelectedIndex = 0;
		}

		void Form_Activated( object sender, EventArgs e )
		{
			_ComboBoxBrailler.UpdateDisplay();
		}
		#endregion

		#region Properties
		/// <summary>
		/// _CAOɕ\ Azuki ̃IvV擾܂͐ݒ肵܂B
		/// </summary>
		public AzukiOption AzukiOption
		{
			get
			{
				AzukiOption option = AzukiOption.Default;

				option.SpeaksLineFromCaret = (_Combo_SpeaksLineFromCaret.SelectedIndex == 1);
				option.SpeaksChangedPartOnSelect = (_Combo_SpeaksChangedPartOnSelect.SelectedIndex == 1);
				option.ConvertsTabToSpaces = _Check_ConvertsTab.Checked;
				option.ConvertsFullWidthSpaceToSpaces = _Check_ConvertsFullWidthSpace.Checked;
				option.HighlightsCurrentLine = _Check_HighlightsCurrentLine.Checked;
				option.ShowsLineNumber = _Check_ShowsLineNumber.Checked;
				try
				{
					option.TabWidth = Int32.Parse( _Edit_TabWidth.Text );
				}
				catch
				{
					Debug.Fail( "Invalid data was input as tab width (not a number)." );
					option.TabWidth = 4;
				}

				return option;
			}
			set
			{
				_Combo_SpeaksLineFromCaret.SelectedIndex = (value.SpeaksLineFromCaret) ? 1 : 0;
				_Combo_SpeaksChangedPartOnSelect.SelectedIndex = (value.SpeaksChangedPartOnSelect) ? 1 : 0;
				_Check_ConvertsTab.Checked = value.ConvertsTabToSpaces;
				_Check_ConvertsFullWidthSpace.Checked = value.ConvertsFullWidthSpaceToSpaces;
				_Check_HighlightsCurrentLine.Checked = value.HighlightsCurrentLine;
				_Check_ShowsLineNumber.Checked = value.ShowsLineNumber;
				_Edit_TabWidth.Text = value.TabWidth.ToString();
			}
		}
		#endregion

		#region UI Event Handlers
		void _Button_Ok_Click( object sender, EventArgs e )
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}
		#endregion

		#region UI Component Initialization
		void LocalizeComponent()
		{
			Localizer localizer = AppLogic.Localizer;

			localizer.TryGetString( "AzukiOptionDialog.Text", this );

			localizer.TryGetString( "AzukiOptionDialog._Group_Speak.Text", _Group_Speak );
			localizer.TryGetString( "AzukiOptionDialog._Label_SpeaksLineFromCaret.Text", _Label_SpeaksLineFromCaret );
			for( int i=0; i<2; i++ )
			{
				string str = _Combo_SpeaksLineFromCaret.Items[i].ToString();
				localizer.TryGetString( "AzukiOptionDialog._Combo_SpeaksLineFromCaret.Items["+i+"].Text", ref str );
				_Combo_SpeaksLineFromCaret.Items[i] = str;
			}
			localizer.TryGetString( "AzukiOptionDialog._Label_SpeaksChangedPartOnSelect.Text", _Label_SpeaksChangedPartOnSelect );
			for( int i=0; i<2; i++ )
			{
				string str = _Combo_SpeaksChangedPartOnSelect.Items[i].ToString();
				localizer.TryGetString( "AzukiOptionDialog._Combo_SpeaksChangedPartOnSelect.Items["+i+"].Text", ref str );
				_Combo_SpeaksChangedPartOnSelect.Items[i] = str;
			}

			localizer.TryGetString( "AzukiOptionDialog._Group_Edit.Text", _Group_Edit );
			localizer.TryGetString( "AzukiOptionDialog._Check_ConvertsTab.Text", _Check_ConvertsTab );
			localizer.TryGetString( "AzukiOptionDialog._Check_ConvertsFullWidthSpace.Text", _Check_ConvertsFullWidthSpace );

			localizer.TryGetString( "AzukiOptionDialog._Group_View.Text", _Group_View );
			localizer.TryGetString( "AzukiOptionDialog._Check_HighlightsCurrentLine.Text", _Check_HighlightsCurrentLine );
			localizer.TryGetString( "AzukiOptionDialog._Check_ShowsLineNumber.Text", _Check_ShowsLineNumber );
			localizer.TryGetString( "AzukiOptionDialog._Label_TabWidth.Text", _Label_TabWidth );

			_Msg_TabWidthMustBeNumeber = localizer.TryGetString( "AzukiOptionDialog._Msg_TabWidthMustBeNumeber", "Please set a number to tab width value." );
		}

		protected override void InstallBraillers()
		{
			_ControlBrailler.Init();
			_ControlBrailler.Add( _Button_Ok );
			_ControlBrailler.Add( _Button_Cancel );
			_ControlBrailler.Add( _Check_ConvertsTab );
			_ControlBrailler.Add( _Check_ConvertsFullWidthSpace );
			_ControlBrailler.Add( _Check_HighlightsCurrentLine );
			_ControlBrailler.Add( _Check_ShowsLineNumber );

			_ComboBoxBrailler.Init();
			_ComboBoxBrailler.Add( _Combo_SpeaksLineFromCaret );
			_ComboBoxBrailler.Add( _Combo_SpeaksChangedPartOnSelect );

			_TextBoxBrailler.Init();
			_TextBoxBrailler.Add( _Edit_TabWidth );
		}

		protected override void InstallReaders()
		{
			_TextBoxReader.Add( _Edit_TabWidth );
			_ComboBoxReader.Add( _Combo_SpeaksLineFromCaret );
			_ComboBoxReader.Add( _Combo_SpeaksChangedPartOnSelect );
		}

		protected override void UninstallBraillers()
		{
			_ControlBrailler.Dispose();
			_ComboBoxBrailler.Dispose();
			_TextBoxBrailler.Dispose();
		}

		protected override void UninstallReaders()
		{
			_TextBoxReader.Dispose();
			_ComboBoxReader.Dispose();
		}

		void InitializeComponent()
		{
			this._Label_TabWidth = new System.Windows.Forms.Label();
			this._Edit_TabWidth = new System.Windows.Forms.TextBox();
			this._Button_Ok = new System.Windows.Forms.Button();
			this._Button_Cancel = new System.Windows.Forms.Button();
			this._Check_ConvertsTab = new System.Windows.Forms.CheckBox();
			this._Combo_SpeaksLineFromCaret = new System.Windows.Forms.ComboBox();
			this._Label_SpeaksLineFromCaret = new System.Windows.Forms.Label();
			this._Group_Edit = new System.Windows.Forms.GroupBox();
			this._Check_ConvertsFullWidthSpace = new System.Windows.Forms.CheckBox();
			this._Group_Speak = new System.Windows.Forms.GroupBox();
			this._Label_SpeaksChangedPartOnSelect = new System.Windows.Forms.Label();
			this._Combo_SpeaksChangedPartOnSelect = new System.Windows.Forms.ComboBox();
			this._Group_View = new System.Windows.Forms.GroupBox();
			this._Check_ShowsLineNumber = new System.Windows.Forms.CheckBox();
			this._Check_HighlightsCurrentLine = new System.Windows.Forms.CheckBox();
			this._Group_Edit.SuspendLayout();
			this._Group_Speak.SuspendLayout();
			this._Group_View.SuspendLayout();
			this.SuspendLayout();
			// 
			// _Label_TabWidth
			// 
			this._Label_TabWidth.Location = new System.Drawing.Point( 14, 67 );
			this._Label_TabWidth.Name = "_Label_TabWidth";
			this._Label_TabWidth.Size = new System.Drawing.Size( 55, 17 );
			this._Label_TabWidth.TabIndex = 2;
			this._Label_TabWidth.Text = "&Tab width";
			// 
			// _Edit_TabWidth
			// 
			this._Edit_TabWidth.Location = new System.Drawing.Point( 90, 64 );
			this._Edit_TabWidth.MaxLength = 3;
			this._Edit_TabWidth.Name = "_Edit_TabWidth";
			this._Edit_TabWidth.ShortcutsEnabled = false;
			this._Edit_TabWidth.Size = new System.Drawing.Size( 44, 19 );
			this._Edit_TabWidth.TabIndex = 3;
			this._Edit_TabWidth.WordWrap = false;
			// 
			// _Button_Ok
			// 
			this._Button_Ok.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this._Button_Ok.Location = new System.Drawing.Point( 196, 333 );
			this._Button_Ok.Name = "_Button_Ok";
			this._Button_Ok.Size = new System.Drawing.Size( 75, 23 );
			this._Button_Ok.TabIndex = 3;
			this._Button_Ok.Text = "OK";
			this._Button_Ok.UseVisualStyleBackColor = true;
			this._Button_Ok.Click += new System.EventHandler( this._Button_Ok_Click );
			// 
			// _Button_Cancel
			// 
			this._Button_Cancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this._Button_Cancel.Location = new System.Drawing.Point( 277, 333 );
			this._Button_Cancel.Name = "_Button_Cancel";
			this._Button_Cancel.Size = new System.Drawing.Size( 75, 23 );
			this._Button_Cancel.TabIndex = 4;
			this._Button_Cancel.Text = "Cancel";
			this._Button_Cancel.UseVisualStyleBackColor = true;
			// 
			// _Check_ConvertsTab
			// 
			this._Check_ConvertsTab.Location = new System.Drawing.Point( 15, 18 );
			this._Check_ConvertsTab.Name = "_Check_ConvertsTab";
			this._Check_ConvertsTab.Size = new System.Drawing.Size( 319, 17 );
			this._Check_ConvertsTab.TabIndex = 0;
			this._Check_ConvertsTab.Text = "Converts an input &tab to spaces";
			this._Check_ConvertsTab.UseVisualStyleBackColor = true;
			// 
			// _Combo_SpeaksLineFromCaret
			// 
			this._Combo_SpeaksLineFromCaret.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this._Combo_SpeaksLineFromCaret.FormattingEnabled = true;
			this._Combo_SpeaksLineFromCaret.Items.AddRange( new object[] {
            "line head",
            "cursor position"} );
			this._Combo_SpeaksLineFromCaret.Location = new System.Drawing.Point( 90, 40 );
			this._Combo_SpeaksLineFromCaret.Name = "_Combo_SpeaksLineFromCaret";
			this._Combo_SpeaksLineFromCaret.Size = new System.Drawing.Size( 244, 20 );
			this._Combo_SpeaksLineFromCaret.TabIndex = 1;
			// 
			// _Label_SpeaksLineFromCaret
			// 
			this._Label_SpeaksLineFromCaret.Location = new System.Drawing.Point( 9, 20 );
			this._Label_SpeaksLineFromCaret.Name = "_Label_SpeaksLineFromCaret";
			this._Label_SpeaksLineFromCaret.Size = new System.Drawing.Size( 325, 17 );
			this._Label_SpeaksLineFromCaret.TabIndex = 0;
			this._Label_SpeaksLineFromCaret.Text = "Speaks &line content after up(down) key from:";
			// 
			// _Group_Edit
			// 
			this._Group_Edit.Controls.Add( this._Check_ConvertsFullWidthSpace );
			this._Group_Edit.Controls.Add( this._Check_ConvertsTab );
			this._Group_Edit.Location = new System.Drawing.Point( 12, 141 );
			this._Group_Edit.Name = "_Group_Edit";
			this._Group_Edit.Size = new System.Drawing.Size( 340, 74 );
			this._Group_Edit.TabIndex = 1;
			this._Group_Edit.TabStop = false;
			this._Group_Edit.Text = "Edit";
			// 
			// _Check_ConvertsFullWidthSpace
			// 
			this._Check_ConvertsFullWidthSpace.Location = new System.Drawing.Point( 15, 41 );
			this._Check_ConvertsFullWidthSpace.Name = "_Check_ConvertsFullWidthSpace";
			this._Check_ConvertsFullWidthSpace.Size = new System.Drawing.Size( 319, 17 );
			this._Check_ConvertsFullWidthSpace.TabIndex = 1;
			this._Check_ConvertsFullWidthSpace.Text = "Converts an input &full-width space to two spaces";
			this._Check_ConvertsFullWidthSpace.UseVisualStyleBackColor = true;
			// 
			// _Group_Speak
			// 
			this._Group_Speak.Controls.Add( this._Label_SpeaksChangedPartOnSelect );
			this._Group_Speak.Controls.Add( this._Combo_SpeaksChangedPartOnSelect );
			this._Group_Speak.Controls.Add( this._Label_SpeaksLineFromCaret );
			this._Group_Speak.Controls.Add( this._Combo_SpeaksLineFromCaret );
			this._Group_Speak.Location = new System.Drawing.Point( 12, 12 );
			this._Group_Speak.Name = "_Group_Speak";
			this._Group_Speak.Size = new System.Drawing.Size( 340, 123 );
			this._Group_Speak.TabIndex = 0;
			this._Group_Speak.TabStop = false;
			this._Group_Speak.Text = "Speak";
			// 
			// _Label_SpeaksChangedPartOnSelect
			// 
			this._Label_SpeaksChangedPartOnSelect.Location = new System.Drawing.Point( 9, 70 );
			this._Label_SpeaksChangedPartOnSelect.Name = "_Label_SpeaksChangedPartOnSelect";
			this._Label_SpeaksChangedPartOnSelect.Size = new System.Drawing.Size( 325, 17 );
			this._Label_SpeaksChangedPartOnSelect.TabIndex = 2;
			this._Label_SpeaksChangedPartOnSelect.Text = "After &selection changed:";
			// 
			// _Combo_SpeaksChangedPartOnSelect
			// 
			this._Combo_SpeaksChangedPartOnSelect.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this._Combo_SpeaksChangedPartOnSelect.FormattingEnabled = true;
			this._Combo_SpeaksChangedPartOnSelect.Items.AddRange( new object[] {
            "Speak char at the new cursor position",
            "Speak part whose selection state has changed"} );
			this._Combo_SpeaksChangedPartOnSelect.Location = new System.Drawing.Point( 90, 90 );
			this._Combo_SpeaksChangedPartOnSelect.Name = "_Combo_SpeaksChangedPartOnSelect";
			this._Combo_SpeaksChangedPartOnSelect.Size = new System.Drawing.Size( 244, 20 );
			this._Combo_SpeaksChangedPartOnSelect.TabIndex = 3;
			// 
			// _Group_View
			// 
			this._Group_View.Controls.Add( this._Check_ShowsLineNumber );
			this._Group_View.Controls.Add( this._Check_HighlightsCurrentLine );
			this._Group_View.Controls.Add( this._Edit_TabWidth );
			this._Group_View.Controls.Add( this._Label_TabWidth );
			this._Group_View.Location = new System.Drawing.Point( 12, 221 );
			this._Group_View.Name = "_Group_View";
			this._Group_View.Size = new System.Drawing.Size( 340, 101 );
			this._Group_View.TabIndex = 2;
			this._Group_View.TabStop = false;
			this._Group_View.Text = "View";
			// 
			// _Check_ShowsLineNumber
			// 
			this._Check_ShowsLineNumber.Location = new System.Drawing.Point( 17, 41 );
			this._Check_ShowsLineNumber.Name = "_Check_ShowsLineNumber";
			this._Check_ShowsLineNumber.Size = new System.Drawing.Size( 317, 17 );
			this._Check_ShowsLineNumber.TabIndex = 1;
			this._Check_ShowsLineNumber.Text = "Shows line &number";
			this._Check_ShowsLineNumber.UseVisualStyleBackColor = true;
			// 
			// _Check_HighlightsCurrentLine
			// 
			this._Check_HighlightsCurrentLine.Location = new System.Drawing.Point( 17, 18 );
			this._Check_HighlightsCurrentLine.Name = "_Check_HighlightsCurrentLine";
			this._Check_HighlightsCurrentLine.Size = new System.Drawing.Size( 317, 17 );
			this._Check_HighlightsCurrentLine.TabIndex = 0;
			this._Check_HighlightsCurrentLine.Text = "Highlights &current line";
			this._Check_HighlightsCurrentLine.UseVisualStyleBackColor = true;
			// 
			// AzukiOptionDialog
			// 
			this.ClientSize = new System.Drawing.Size( 364, 368 );
			this.Controls.Add( this._Group_Speak );
			this.Controls.Add( this._Group_View );
			this.Controls.Add( this._Group_Edit );
			this.Controls.Add( this._Button_Cancel );
			this.Controls.Add( this._Button_Ok );
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "AzukiOptionDialog";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Azuki Options";
			this._Group_Edit.ResumeLayout( false );
			this._Group_Speak.ResumeLayout( false );
			this._Group_View.ResumeLayout( false );
			this._Group_View.PerformLayout();
			this.ResumeLayout( false );

		}
		#endregion

		#region UI Components
		Label		_Label_TabWidth;
		Button		_Button_Ok;
		Button		_Button_Cancel;
		CheckBox	_Check_ConvertsTab;
		ComboBox	_Combo_SpeaksLineFromCaret;
		Label		_Label_SpeaksLineFromCaret;
		GroupBox	_Group_Edit;
		GroupBox	_Group_Speak;
		GroupBox	_Group_View;
		CheckBox	_Check_ConvertsFullWidthSpace;
		CheckBox	_Check_HighlightsCurrentLine;
		CheckBox	_Check_ShowsLineNumber;
		Label		_Label_SpeaksChangedPartOnSelect;
		ComboBox	_Combo_SpeaksChangedPartOnSelect;
		TextBox		_Edit_TabWidth;

		TextBoxReader _TextBoxReader = new TextBoxReader();
		ComboBoxReader _ComboBoxReader = new ComboBoxReader();
		ControlBrailler _ControlBrailler = new ControlBrailler();
		ComboBoxBrailler _ComboBoxBrailler = new ComboBoxBrailler();
		TextBoxBrailler _TextBoxBrailler = new TextBoxBrailler();
		#endregion
	}
}
