// file: AppLogic.cs
// brief: application logic
// update: 2012-03-25
//=========================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Windows.Forms;
using CancelEventArgs = System.ComponentModel.CancelEventArgs;
using CancelEventHandler = System.ComponentModel.CancelEventHandler;
using Debug = System.Diagnostics.Debug;
using StackFrame = System.Diagnostics.StackFrame;
using Thread = System.Threading.Thread;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	/// <summary>
	/// AiB Edit ̃AvP[VWbNB
	/// </summary>
	/// <remarks>
	/// CX^X MainForm w肵ȂƐɓ삵ȂB
	/// _̎gpsgpɊւ炸 TextEditorBrailler ɂ͏ Editor o^B
	/// </remarks>
	partial class AppLogic : IDisposable
	{
		#region Fields
		const string FileSelectionFilter = "All files(*.*)|*.*|Text files(*.txt, *.c, ...)|*.txt;*.tex;*.java;*.rb;*.pl;*.py;*.c;*.cpp;*.cxx;*.cs;*.h;*.hpp;*.hxx;*.vbs;*.bat;*.ini;*.inf;*.js";
		static Localizer _Localizer = new Localizer();
		AiBEditForm _MainForm;
		List<Document> _Documents = new List<Document>( 8 );
		Document _ActiveDocument;
		bool _ProcessingActivatedEvent = false;
		AzukiEditReader _AzukiEditReader = new AzukiEditReader();
		int _UntitledDocumentNum = 1;
		int _SwitchingDocument_Index = 0;
		string _Msg_OverwriteModeOn = "overwrite mode";
		string _Msg_OverwriteModeOff = "insert mode";
		string _Msg_NoCharactersToExport = "There is no characters in this document.";
		string _Msg_NBSEngineNotInstalled = "NBS Engine is not installed.";
		string _Msg_FailedToInitializeBrailleDisplay = "Failed to initialize Braille display. {0}";
		string _Msg_BrailleConverterNotInstalled = "Braille file conversion library is not installed.";
		string _Msg_BrailleConverterFailedToInitialized= "failed to initialize library to convert braille file.";
		#endregion

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐B
		/// </summary>
		public AppLogic( int line, int column, string filePath )
		{
			// init application
			AppLogic.Localizer.LoadResourceFile( "AiBEdit" );
			AppConfig.Init();
			AppConfig.LoadConfig();
			try
			{
				BrlCvt.Init();
				BrlCvt.SetLogFilePath( AppConfig.ExportLogFilePath );
			}
			catch{}

			// get localized message text
			Localizer.TryGetString( "AppLogic._Msg_OverwriteModeOn", ref _Msg_OverwriteModeOn );
			Localizer.TryGetString( "AppLogic._Msg_OverwriteModeOff", ref _Msg_OverwriteModeOff );
			Localizer.TryGetString( "AppLogic._Msg_NoCharactersToExport", ref _Msg_NoCharactersToExport );
			Localizer.TryGetString( "AppLogic._Msg_NBSEngineNotInstalled", ref _Msg_NBSEngineNotInstalled );
			Localizer.TryGetString( "AppLogic._Msg_BrailleConverterNotInstalled", ref _Msg_BrailleConverterNotInstalled );
			Localizer.TryGetString( "AppLogic._Msg_BrailleConverterFailedToInitialized", ref _Msg_BrailleConverterFailedToInitialized );
			
			// init main window
			MainForm = new AiBEditForm( this );
			SharedData.Init( MainForm.Handle );

			// prepare init document
			if( filePath != String.Empty )
			{
				bool ok = OpenDocument( filePath );
				if( ok )
				{
					int lineIndex = (line <= 0) ? 0 : line-1;
					int columnIndex = (column <= 0) ? 0 : column-1;
					ActiveDocument.SetCaretIndex( lineIndex, columnIndex );
				}
				else
				{
					// cancel opening. close empty document and create untitled one
					CloseDocument();
					CreateUntitledDocument();
				}
			}
			else
			{
				CreateUntitledDocument();
			}

			// apply config
			ApplyAppConfig();
		}

		/// <summary>
		/// gpĂ\[X܂B
		/// </summary>
		public void Dispose()
		{
			Debug.Assert( _Documents.Count == 0 );
			Debug.Assert( _ActiveDocument == null );

			if( _MainForm != null )
				_MainForm.Dispose();

			TextEditorBrailler.Inst.Dispose();
			_AzukiEditReader.Dispose();

			SharedData.DeleteSharedDataFile();
			NbsEngine.Dispose();
		}

		/// <summary>
		/// AvP[ṼbZ[W[vsB
		/// </summary>
		public void Run()
		{
			Application.Run( _MainForm );
		}

		/// <summary>
		/// AvP[Vݒ𔽉f܂B
		/// </summary>
		public void ApplyAppConfig()
		{
			// AvŜ̐ݒKp
			_AzukiEditReader.SpeaksAfterCaretOnLineChange = AppConfig.AzukiOption.SpeaksLineFromCaret;
			_AzukiEditReader.SpeaksChangedPartOnSelect = AppConfig.AzukiOption.SpeaksChangedPartOnSelect;
			foreach( Document doc in _Documents )
			{
				ApplyEditorConfig( doc );
			}
		}

		/// <summary>
		/// eLXgGfB^̐ݒ𔽉f܂B
		/// </summary>
		public void ApplyEditorConfig( Document doc )
		{
			doc.Editor.UseSmartHome = AppConfig.UseSmartHome;
			doc.Editor.SetFileType( doc.FileType.Name, AppConfig.AutoIndentMode );
			if( doc.Editor is AzukiEdit )
			{
				AzukiEdit azuki = (AzukiEdit)doc.Editor;
				azuki.ConvertsFullWidthSpaceToSpace = AppConfig.AzukiOption.ConvertsFullWidthSpaceToSpaces;
				azuki.ConvertsTabToSpaces = AppConfig.AzukiOption.ConvertsTabToSpaces;
				azuki.HighlightsCurrentLine = AppConfig.AzukiOption.HighlightsCurrentLine;
				azuki.ShowsLineNumber = AppConfig.AzukiOption.ShowsLineNumber;
				azuki.TabWidth = AppConfig.AzukiOption.TabWidth;
			}
		}
		#endregion

		/// <summary>
		/// [JCYwp[
		/// </summary>
		public static Localizer Localizer
		{
			get{ return _Localizer; }
		}

		#region View / Document
		/// <summary>
		/// CEBhE擾܂͐ݒB
		/// </summary>
		public AiBEditForm MainForm
		{
			get{ return _MainForm; }
			set
			{
				Debug.Assert( _MainForm == null, "MainForm must be set only once." );

				_MainForm = value;
				_MainForm.Closing += Form_Closing;
				_MainForm.Closed += Form_Closed;
				_MainForm.Activated += Form_Activated;
				_MainForm.Deactivate += Form_Deactivate;
				_MainForm.Shown += Form_Shown;

				_MainForm.TabControl.TabClicked += TabControl_TabClicked;

				// t@Cʂj[ɒǉ
				foreach( IFileType fileType in FileTypeRepository.AllFileTypes )
				{
					MyMenuItem mi = new MyMenuItem();
					mi.Text = fileType.Name;
					mi.Tag = fileType;
					mi.Click += EditModeMenuItem_Click;
					_MainForm.EditModeMenu.MenuItems.Add( mi );
				}

				// uŋߎgt@Cvj[XV
				UpdateMruFileMenu();
			}
		}

		/// <summary>
		/// ANeBuȃhLg擾܂B
		/// </summary>
		public Document ActiveDocument
		{
			get{ return _ActiveDocument; }
		}

		/// <summary>
		/// ׂẴhLg擾܂B
		/// </summary>
		public List<Document> Documents
		{
			get{ return _Documents; }
		}
		#endregion

		#region Menu/Dialog control
		/// <summary>
		/// uŋߎgt@Cvj[XV
		/// </summary>
		void UpdateMruFileMenu()
		{
			string[]	mru;
			string		fileName;
			MyMenuItem	mi;

			// MRU 擾
			mru = AppConfig.Get17MruFilePaths();
			if( mru.Length == 0 )
			{
				_MainForm.MruMenu.Enabled = false;
				return;
			}

			// j[XV
			_MainForm.MruMenu.Enabled = true;
			_MainForm.MruMenu.MenuItems.Clear();
			for( int mruIndex=0; mruIndex<mru.Length; mruIndex++ )
			{
				string mruFilePath = mru[mruIndex];
				fileName = Path.GetFileName( mruFilePath );
				mi = new MyMenuItem();
				mi.Text = String.Format( "{0:X} {1}", mruIndex, fileName );
				mi.Tag = mruFilePath;
				mi.Click += MruMenuItem_Clicked;
				_MainForm.MruMenu.MenuItems.Add( mi );
			}
		}

		/// <summary>
		/// MRU t@C̃j[ڂIꂽ̓B
		/// </summary>
		void MruMenuItem_Clicked( object sender, EventArgs e )
		{
			MyMenuItem mi = (MyMenuItem)sender;
			string filePath = (string)mi.Tag;

			// open the document
			OpenDocument( filePath );
		}

		/// <summary>
		/// uҏW[hvj[̕\XV
		/// </summary>
		void UpdateEditModeMenu()
		{
			foreach( MyMenuItem mi in _MainForm.EditModeMenu.MenuItems )
			{
				// et@CIuWFNg͗BȂ̂Ńnhlœ
				if( ActiveDocument.FileType.GetHashCode() == mi.Tag.GetHashCode() )
					mi.Checked = true;
				else
					mi.Checked = false;
			}
		}

		/// <summary>
		/// IvV_CAO\
		/// </summary>
		public void ShowOptionDialog()
		{
			DialogResult result;

			using( OptionDialog dialog = new OptionDialog() )
			{
				// show dialog
				result = dialog.ShowDialog( _MainForm );
				
				// reset braille config
				if( NbsEngine.Instance != null )
				{
					NbsEngine.Instance.BrailleConfig = AppConfig.BrailleConfig;
				}
				
				// if user pressed ok button, apply changes
				if( result == DialogResult.OK )
				{
					AppConfig.EngineType = (dialog.UseAzuki ? "Azuki" : "RichEdit");
					AppConfig.UseSmartHome = dialog.UseSmartHome;
					AppConfig.AutoIndentMode = dialog.AutoIndentMode;
					AppConfig.AzukiOption = dialog.AzukiOption;

					ApplyAppConfig();
				}
			}
		}
		#endregion

		#region MDI 
		/// <summary>
		/// X̏ޗpj[ڂNbNꂽ̓
		/// </summary>
		void DocMenu_Click( object sender, EventArgs e )
		{
			MyMenuItem mi = (MyMenuItem)sender;
			DocViewMan_Activate( (Document)mi.Tag );
		}

		/// <summary>
		/// ނ̃^uNbNꂽ̓B
		/// ^uɊ֘Atꂽނ
		/// NbNȂANeBuɁA
		/// NbNȂB
		/// </summary>
		void TabControl_TabClicked( MouseButtons button, int index, object tag )
		{
			if( button == MouseButtons.Left )
			{
				DocViewMan_Activate( (Document)tag );
				AutoSpeaker.Instance.Stop();
				AutoSpeaker.Instance.Speak( ActiveDocument.DisplayName );
			}
			else if( button == MouseButtons.Middle )
			{
				DocViewMan_Activate( (Document)tag );
				CloseDocument();
			}
		}

		/// <summary>
		/// ނ̐؂ւJn
		/// </summary>
		/// <remarks>ۂɂ͉Ȃ</remarks>
		public void BeginSwitchingDocument()
		{}

		/// <summary>
		/// ނ̐؂ւIB
		/// ނёւB
		/// </summary>
		public void EndSwitchingDocument()
		{
			// ŏIIɃANeBuɂȂނXg̐擪ɂ
			Document activatedDoc = (Document)_Documents[_SwitchingDocument_Index];
			_Documents.RemoveAt( _SwitchingDocument_Index );
			_Documents.Insert( 0, activatedDoc );
			
			_SwitchingDocument_Index = 0;
		}

		/// <summary>
		/// ̏ނɐ؂ւB
		/// </summary>
		public void SwitchToNextDocument()
		{
			if( _SwitchingDocument_Index < _Documents.Count )
				_SwitchingDocument_Index++;
			else
				_SwitchingDocument_Index = 0;
			DocViewMan_Activate( (Document)_Documents[_SwitchingDocument_Index] );
		}

		/// <summary>
		/// Ȍނɐ؂ւB
		/// </summary>
		public void SwitchToPreviousDocument()
		{
			if( 0 < _SwitchingDocument_Index )
				_SwitchingDocument_Index--;
			else
				_SwitchingDocument_Index = _Documents.Count - 1;
			DocViewMan_Activate( (Document)_Documents[_SwitchingDocument_Index] );
		}
		#endregion

		#region ނ̏
		/// <summary>
		/// ҏW[h̃j[ڂNbNꂽ̓
		/// </summary>
		void EditModeMenuItem_Click( object sender, EventArgs e )
		{
			MyMenuItem mi = (MyMenuItem)sender;
			ActiveDocument.FileType = (IFileType)mi.Tag;

			// `FbNt
			foreach( MyMenuItem newMI in _MainForm.EditModeMenu.MenuItems )
			{
				if( newMI != mi )
				{
					newMI.Checked = false;
				}
			}
			mi.Checked = true;
		}

		/// <summary>
		/// ނύXꂽ̓
		/// </summary>
		void Document_DirtyStateChanged( object sender, EventArgs e )
		{
			Debug.Assert( sender != null );
			Debug.Assert( sender is ITextEditor );
			Debug.Assert( ((ITextEditor)sender).Tag is Document );

			ITextEditor editor;

			editor = (ITextEditor)sender;
			DocViewMan_UpdateUI( (Document)editor.Tag );
		}

		DialogResult ConfirmDiscardChanges()
		{
			string format = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_DiscardChanges", "{0} was changed. Are you sure to discard changes?" );
			return NbsMessageBox.Show( _MainForm, String.Format(format, ActiveDocument.FileName), MessageBoxButtons.YesNo, MessageBoxIcon.Warning );
		}

		#endregion

		#region CtH[̃Cxg
		/// <summary>
		/// CtH[钼O̊mFB
		/// {ɏIĂ̂[Uɖ₢킹B
		/// </summary>
		void Form_Closing( object sender, CancelEventArgs e )
		{
			DialogResult result;
			bool notCanceled;

			// ۑ̃hLgۑ邩₢킹
			foreach( Document doc in _Documents )
			{
				if( !doc.IsModified )
					continue;

				// ۑ邩
				result = Utl.AskToSaveDocument( _MainForm, doc );
				if( result == DialogResult.Yes )
				{
					// ㏑ۑ
					notCanceled = SaveDocument( doc );
					if( !notCanceled )
					{
						result = DialogResult.Cancel;
					}
				}
				
				// ۑLZꂽꍇ́AŜLZ
				if( result == DialogResult.Cancel )
				{
					e.Cancel = true;
					return;
				}
			}

			// hLgׂĔj
			while( 0 < _Documents.Count )
			{
				_Documents[_Documents.Count-1].Dispose();
				_Documents.RemoveAt( _Documents.Count-1 );
			}
			_ActiveDocument = null;
		}

		/// <summary>
		/// CtH[̓B
		/// eIsB
		/// </summary>
		void Form_Closed( object sender, EventArgs e )
		{
			Debug.Assert( _Documents.Count == 0, "Document.Count is not 0 but Form was closed." );
			Debug.Assert( _ActiveDocument == null, "ActiveDocument is null but Form was closed." );

			// EBhËʒuETCYEő剻Ԃۑ
			if( _MainForm.WindowState == FormWindowState.Maximized )
			{
				AppConfig.WindowMaximized = true;
			}
			else
			{
				AppConfig.WindowMaximized = false;
				AppConfig.WindowLocation = _MainForm.Location;
				AppConfig.WindowSize = _MainForm.Size;
			}

			// save config before EndUsingBraille (this sets AppConfig.UsingBraille to false)
			AppConfig.SaveConfig();

			// _fBXvC܂̃\[X
			EndUsingBraille();
		}

		/// <summary>
		/// tH[߂ĕ\ꂽ̓B
		/// </summary>
		void Form_Shown( object sender, EventArgs e )
		{
			if( JawsSpeaker.IsAlive() )
			{
				JawsSpeaker.Instance.Stop();
			}
		}

		/// <summary>
		/// tH[ANeBuɂȂ̓B
		/// ANeBuԂɑAvҏWt@CĂAēǍ邩[UɊmFB
		/// ܂AANeBułȂȂɉ_fBXvCgpĎ擾B
		/// </summary>
		void Form_Activated( object sender, EventArgs e )
		{
			//---- Aṽt@C㎞ɍēǍ邩mF ----
			// ēǍ̊mFbZ[W{bNX\ĕƁAtH[܂ANeBuɂȂB
			// ܂CxgۂĔĖ[vIȋɂȂB
			// 邽߁AtO𗧂Ăĕ񂱂ɓȂ悤ɂ
			if( Utl.InterlockedSetFlagTrue(this, ref _ProcessingActivatedEvent) )
			{
				List<Document> changedDocs = new List<Document>( _Documents.Count );
				foreach( Document doc in _Documents )
				{
					DialogResult result;

					// et@C̍XViANeBuɕۑj
					// ύXĂ邩mF
					if( File.Exists(doc.Path) == false
						|| File.GetLastWriteTime(doc.Path) <= doc.LastSaveTime )
					{
						continue; // ύXĂȂ̂
					}

					// ǂݒq˂
					result = Form_Activated_ConfirmReload( doc );
					if( result != DialogResult.Yes )
					{
						continue;
					}

					// ǂݒΏۂɒǉ
					changedDocs.Add( doc );
				}

				foreach( Document doc in changedDocs )
				{
					int lineIndex, columnIndex;
					bool reloaded;

					// ǂݒ
					doc.GetCaretIndex( out lineIndex, out columnIndex );
					reloaded = ReloadDocument( doc ); // ŎsNƎIɕ
					if( reloaded )
					{
						doc.SetCaretIndex( lineIndex, columnIndex );
						doc.Editor.ScrollToCaret();
					}
				}

				//---- _fBXvC̐ĊJ ----
				if( AppConfig.UsingBraille )
				{
					BeginUsingBraille();
					TextEditorBrailler.Inst.UpdateDisplay();
				}

				_ProcessingActivatedEvent = false;
			}
		}

		DialogResult Form_Activated_ConfirmReload( Document doc )
		{
			string	format;
			string	message;

			// bZ[W𐶐
			format = AppLogic.Localizer.TryGetString(
					"AiBEditForm.Msg_UpdatedByOtherProcess",
					"{0} was modified by other program. Reload file?"
				);
			message = String.Format( format, Path.GetFileName(doc.Path) );

			// t@Cǂݒǂ[Uɖ₢킹
			return NbsMessageBox.Show( _MainForm, message, MessageBoxButtons.YesNo, MessageBoxIcon.Warning );
		}

		/// <summary>
		/// tH[ANeBuɂȂ钼O̓B
		/// Av̂߂ɓ_fBXvCgpB
		/// </summary>
		void Form_Deactivate( object sender, EventArgs e )
		{
			// _fBXvC̎gp
			if( AppConfig.UsingBraille
				&& NbsEngine.Instance != null
				&& NbsEngine.Instance.IsAttached )
			{
				NbsEngine.Instance.Unlock();
			}
		}
		#endregion

		#region _fBXvC̑
		/// <summary>
		/// _fBXvC̎gpJn
		/// </summary>
		public void BeginUsingBraille()
		{
			// NBS GWCXg[Ă邩mF
			if( !NbsEngine.Installed )
			{
				string message;

				// CXg[ĂȂ̂ŕsgpɐݒύX
				AppConfig.UsingBraille = _MainForm.UsingBraille = false;

				// ̎|ʒm
				message = AppLogic.Localizer.TryGetString(
					"AiBEditForm.Msg_NBSEngineNotInstalled", "NBS Engine is not installed." );
				NbsMessageBox.Show( _MainForm, message, MessageBoxButtons.OK, MessageBoxIcon.Error );
				return;
			}

			try
			{
				// _fBXvC̎gpJn
				NbsEngine.Instance.DeviceConfig = AppConfig.DeviceConfig;
				NbsEngine.Instance.AttachToServer();
				NbsEngine.Instance.Lock();

				// _̏ڍׂȕ\ݒs
				NbsEngine.Instance.BrailleConfig = AppConfig.BrailleConfig;

				// ݒۑ
				AppConfig.UsingBraille = _MainForm.UsingBraille = true;

				// fBXvC\XV
				NbsEngine.Instance.UpdateDisplay();
			}
			catch( AttachFailedException ex )
			{
				string msg = String.Format( _Msg_FailedToInitializeBrailleDisplay, ex.Message );
				NbsMessageBox.Show( _MainForm, msg, MessageBoxButtons.OK, MessageBoxIcon.Error );
				AppConfig.UsingBraille = _MainForm.UsingBraille = false;
			}
		}

		/// <summary>
		/// _fBXvC̎gp~
		/// </summary>
		public void EndUsingBraille()
		{
			// \NA
			NbsEngine.Instance.ClearDisplay();
			Thread.CurrentThread.Join( 80 ); // [*1]

			// T[oؒf
			NbsEngine.Instance.DetachFromServer();

			// GUI XV
			AppConfig.UsingBraille = _MainForm.UsingBraille = false;

			// \NA Detach ĂԂƃNAOɃf^b`邱Ƃ
		}
		
		/// <summary>
		/// _fBXvC̋@ݒ
		/// </summary>
		public void ConfigureBrailleDevice()
		{
			DialogResult result;
			BrailleDevice prevDevice = AppConfig.DeviceConfig.Device;

			// foCXݒ_CAO\
			using( DeviceConfigForm form = new DeviceConfigForm(AppConfig.DeviceConfig) )
			{
				form.StartPosition = FormStartPosition.CenterParent;
				result = form.ShowDialog( _MainForm );
				if( result != DialogResult.OK )
				{
					return; // LZꂽ
				}

				// foCXݒXV
				AppConfig.DeviceConfig = form.DeviceConfig;
				if( prevDevice != AppConfig.DeviceConfig.Device )
				{
					// @킪ύXꂽꍇ͂̋@̃Z
					// _󃂁[h̐܂ԂĐݒ
					AppConfig.BrailleConfig.TenyakuMaxWidth = AppConfig.DeviceConfig.CellCount;
				}
			}

			// _GWċN
			if( AppConfig.UsingBraille )
			{
				EndUsingBraille();
				Thread.CurrentThread.Join( 2000 ); // EndABegin ƒZԂŌĂԂƂ܂ WinPin.exe ̍ċNԂɍȂ
				BeginUsingBraille();
			}
		}
		
		/// <summary>
		/// _fBXvC̓_̌nݒ
		/// </summary>
		public void ConfigureBrailleSystem()
		{
			DialogResult result;

			// _\ݒ_CAO\
			using( BrailleConfigForm form = new BrailleConfigForm(AppConfig.BrailleConfig) )
			{
				form.StartPosition = FormStartPosition.CenterParent;
				result = form.ShowDialog( _MainForm );
				if( result != DialogResult.OK )
				{
					return; // LZꂽ
				}

				// _\ݒXV
				AppConfig.BrailleConfig = form.BrailleConfig;
				if( NbsEngine.Instance != null )
				{
					NbsEngine.Instance.BrailleConfig = AppConfig.BrailleConfig;
				}
			}

			// _fBXvC̕\XV
			TextEditorBrailler.Inst.UpdateDisplay();
		}
		#endregion // _fBXvC̑

		#region Utilities
		void Alert( Exception ex )
		{
			NbsMessageBox.Show( _MainForm, ex.Message, MessageBoxButtons.OK, MessageBoxIcon.Error );
		}

		partial class Utl
		{
			/// <summary>
			/// NeBJZNVŃtÕ`FbNƏsA
			/// tO̒lύXꂽꍇ true Ԃ܂B
			/// </summary>
			/// <returns>tOύXꂽǂ</returns>
			public static bool InterlockedSetFlagTrue( object lockObj, ref bool flag )
			{
				lock( lockObj )
				{
					bool rc = false;

					if( flag != true )
					{
						flag = true;
						rc = true;
					}
					return rc;
				}
			}

			public static MyMenuItem FindWindowMenuItem( AiBEditForm form, Document doc )
			{
				Debug.Assert( doc != null );

				foreach( MyMenuItem item in form.WindowMenu.MenuItems )
				{
					if( item.Tag == doc )
					{
						return (MyMenuItem)item;
					}
				}

				return null;
			}

			public static void RemoveDocumentFromWindowMenu( AiBEditForm form, Document doc )
			{
				MyMenuItem mi;

				mi = FindWindowMenuItem( form, doc );
				form.WindowMenu.MenuItems.Remove( mi );
				mi.Tag = null;
				mi.Dispose();
			}
		}
		#endregion
	}
}
