// file: AppLogic.IO.cs
// brief: application logic (file I/O part)
// update: 2012-02-26
//=========================================================
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;
using Debug = System.Diagnostics.Debug;
using SecurityException = System.Security.SecurityException;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	partial class AppLogic
	{
		#region Create
		/// <summary>
		/// VhLg𐶐܂B
		/// </summary>
		Document CreateDocument()
		{
			Document doc = new Document();

			// hLgݒ肷
			doc.FileType = FileTypeRepository.GetByTypeName( null );
			ApplyEditorConfig( doc );

			return doc;
		}

		/// <summary>
		/// V̏ނ𐶐܂B
		/// </summary>
		public void CreateUntitledDocument()
		{
			Document doc = CreateDocument();

			// UI XV
			doc.DisplayName = "Untitled" + _UntitledDocumentNum++;
			DocViewMan_Add( doc );
			DocViewMan_Activate( doc );
		}

		/// <summary>
		/// ނ܂B
		/// </summary>
		/// <returns>ύXςݏނ̂[ULZǂB</returns>
		public bool CloseDocument()
		{
			bool canceled;
			Document doc = _ActiveDocument;
			
			// ANeBuȃhLg
//			_ActiveDocument = null;
			canceled = CloseDocument( doc );
			if( canceled )
			{
				_ActiveDocument = doc; // LZꂽANeBuȃhLgɐݒ肵Ȃ
				return true;
			}

			// ʂ̃hLgANeBu
			if( 0 < _Documents.Count )
			{
				DocViewMan_Activate( (Document)_Documents[0] );
				//DO_NOT//AutoSpeaker.Instance.Stop();
				AutoSpeaker.Instance.Speak( ActiveDocument.DisplayName );
			}
			else
			{
				_MainForm.ResetText();
				_MainForm.EnableEditMenuItems( false );
				_MainForm.EnableWindowSwitchMenuItems( false );
				if( NbsEngine.Instance != null )
					NbsEngine.Instance.ClearDisplay();
			}

			return false;
		}

		/// <summary>
		/// hLg܂B
		/// </summary>
		/// <param name="doc">Ώۂ̃hLg</param>
		/// <returns>ύXς݃hLg̂[ULZǂB</returns>
		public bool CloseDocument( Document doc )
		{
			bool ok;
			DialogResult result;

			if( doc == null /*|| _Documents.Count == 0*/ )
				return false;

			// if already modified, ask user to save it or not.
			if( doc.IsModified )
			{
				result = Utl.AskToSaveDocument( _MainForm, doc );
				if( result == DialogResult.Yes )
				{
					ok = SaveDocument( doc );
					if( !ok )
					{
						return true;
					}
				}
				else if( result == DialogResult.Cancel )
				{
					return true;
				}
			}

			// tell user that the file was closed
			// i95 Reader ͘AŔƌ㑱ȂA
			// ԂƔȂmB
			// ŁA\Ȍ葁uN[Yv𔭉A
			// ʂƂĒɃANeBuɂȂ鏑ޖ܂ł
			// ԂB
			AutoSpeaker.Instance.Stop();
			AutoSpeaker.Instance.Speak( "Close" );

			// MRU ۑ
			if( doc.IsNewFile == false )
			{
				AppConfig.AddMru( doc );
			}

			// remove UI
			int index = _Documents.IndexOf( doc );
			DocViewMon_Remove( doc );
			if( ActiveDocument == doc )
			{
				if( _Documents.Count <= index )
					index = _Documents.Count - 1;
				if( 0 <= index )
				{
					// ANeBuȃhLgꍇ͕ʂ̂̂ANeBu
					DocViewMan_Activate( _Documents[index] );
				}
				else
				{
					_ActiveDocument = null;
				}
			}
			
			// dispose document
			doc.Dispose();

			return false;
		}
		#endregion

		#region Open
		/// <summary>
		/// t@CI[v_CAO\āA
		/// t@CJ܂B
		/// </summary>
		public void OpenDocument()
		{
			string fileName;
			Encoding encoding;
			bool withBom;

			try
			{
				// setup dialog window
				using( OpenFileDialog dialog = new OpenFileDialog() )
				{
					DialogResult result;

					dialog.StartPosition = FormStartPosition.CenterParent;
					dialog.Filter = FileSelectionFilter;
					dialog.FilterIndex = 1;
					if( ActiveDocument != null )
					{
						// set initial value from the active document
						if( File.Exists(ActiveDocument.Path) )
						{
							dialog.InitialDirectory = Path.GetDirectoryName( ActiveDocument.Path );
						}
						dialog.FileName = ActiveDocument.FileName;
					}

					// show dialog
					result = dialog.ShowDialog( _MainForm );
					if( result == DialogResult.Cancel )
					{
						TextEditorBrailler.Inst.UpdateDisplay();
						return;
					}

					// if specified file doesn't exist, create an empty file.
					if( File.Exists(dialog.FileName) == false )
					{
						File.Create( dialog.FileName ).Close();
					}

					// _CAOŃ[Uw肵p^ꎞۑ
					fileName = dialog.FileName;
					encoding = dialog.Encoding;
					withBom = dialog.WithBom;
				}

				// w肳ꂽt@CJ
				OpenDocument( fileName, encoding, withBom );
			}
			catch( IOException ex )
			{
				Alert( ex );
				TextEditorBrailler.Inst.UpdateDisplay();
			}
			catch( UnauthorizedAccessException ex )
			{
				Alert( ex );
				TextEditorBrailler.Inst.UpdateDisplay();
			}
			catch( NotSupportedException ex )
			{
				Alert( ex );
				TextEditorBrailler.Inst.UpdateDisplay();
			}
			catch( System.Security.SecurityException ex )
			{
				Alert( ex );
				TextEditorBrailler.Inst.UpdateDisplay();
			}
		}

		/// <summary>
		/// t@CJ܂B
		/// GR[fBOt@Cʂ͎肵܂B
		/// </summary>
		public bool OpenDocument( string filePath )
		{
			return OpenDocument( filePath, null, false );
		}

		/// <summary>
		/// t@CJA݃ANeBuȃEBhEɓǂݍ݂܂B
		/// </summary>
		/// <returns>ǂB</returns>
		bool OpenDocument( string filePath, Encoding encoding, bool withBom )
		{
			Debug.Assert( filePath != null );

			Document newActiveDoc;
			int caretLine=0, caretColumn=0;
			IFileType fileType = null;

			NbsEngine.Instance.BeginUpdate();

			// [UIt@CłɕҏW̏ꍇA
			// ANeBuɂďI
			Document existingDoc = Utl.FindDocumentByPath( _Documents, filePath );
			if( existingDoc != null )
			{
				DocViewMan_Activate( existingDoc );
				return true;
			}

			// pX̑啶CAwp[^ MRU ŏ㏑
			filePath = Utl.ReGetFilePath( filePath );
			AppConfig.GetMruFileInfo( filePath, ref encoding, ref withBom, ref caretLine, ref caretColumn );
			if( fileType == null )
			{
				fileType = FileTypeRepository.GetByFilePath( filePath );
			}

			// ǂݍރt@Cp̃hLgIuWFNgp
			newActiveDoc = CreateDocument();

			// J
			try
			{
				newActiveDoc.Open( filePath, encoding, withBom );
				newActiveDoc.FileType = fileType;
				newActiveDoc.SetCaretIndex( caretLine, caretColumn );
				newActiveDoc.Editor.ScrollToCaret();
			}
			catch( IOException ex )
			{
				Utl.AlertFailedToOpenFile( _MainForm, Path.GetFileName(filePath), ex );
				newActiveDoc.Dispose();
				return false;
			}

			// MRU ۑ
			AppConfig.AddMru( newActiveDoc );

			// Dirty tO낷
			newActiveDoc.Editor.IsDirty = false;

			// ǗΏۂɓo^iUI Ƃ̓XVȂǂsj
			DocViewMan_Add( newActiveDoc );
			if( _ActiveDocument != null && _ActiveDocument.IsNewFile )
			{
				DocViewMon_Remove( _ActiveDocument );
				_ActiveDocument.Dispose();
				_ActiveDocument = null;
			}
			DocViewMan_Activate( newActiveDoc );

			// VJނ̖Oǂݏグ
			TextEditorBrailler.Inst.UpdateDisplay();
			if( AutoSpeaker.IsAlive() )
			{
				string format = AppLogic.Localizer.TryGetString( "Msg_Opened", "{0} was opened." );
				AutoSpeaker.Instance.Stop();
				AutoSpeaker.Instance.Speak( String.Format(format, ActiveDocument.DisplayName) );
			}

			NbsEngine.Instance.EndUpdate();

			return true;
		}
		#endregion

		#region Save
		/// <summary>
		/// t@C㏑ۑ
		/// </summary>
		/// <returns>[ULZuȂvǂB</returns>
		public bool SaveDocument( Document doc )
		{
			bool ok;

			// t@CJĂȂA邢͐VK쐬eۑĂȂȂ
			// uOtĕۑvɐ؂ւ
			if( doc.Path == null )
			{
				return SaveDocumentAs();
			}

			// eύXĂȂȂ牽Ȃ
			if( doc.IsModified == false )
			{
				return true;
			}

			// ㏑ۑ
			ok = SaveDocument( doc, doc.Path, doc.Encoding, doc.WithBom, doc.EolCode );
			if( !ok )
			{
				// failed to save for some reason
				return false;
			}

			// UI XV
			DocViewMan_UpdateUI( doc );

			return true;
		}
		
		/// <summary>
		/// t@Cʖŕۑ
		/// </summary>
		/// <returns>[ULZuȂvǂB</returns>
		public bool SaveDocumentAs()
		{
			DialogResult result;
			bool ok;
			string filePath;
			Encoding encoding;
			bool withBom;
			EolCode eolCode;
			
			// ۑ_CAO\
			using( SaveFileDialog dialog = new SaveFileDialog() )
			{
				// setup dialog window
				dialog.StartPosition = FormStartPosition.CenterParent;
				dialog.FileName = ActiveDocument.FileName;
				dialog.Filter = FileSelectionFilter;
				dialog.Encoding = ActiveDocument.Encoding;
				dialog.WithBom = ActiveDocument.WithBom;
				dialog.EolCode = ActiveDocument.EolCode;
				if( File.Exists(ActiveDocument.Path) )
				{
					dialog.InitialDirectory = Path.GetDirectoryName( ActiveDocument.Path );
				}

				// ۑ_CAO\
				result = dialog.ShowDialog( _MainForm );
				if( result == DialogResult.Cancel )
				{
					return false;
				}

				// get parameters
				filePath = dialog.FileName;
				encoding = dialog.Encoding;
				withBom = dialog.WithBom;
				eolCode = dialog.EolCode;
			}

			// before save, check whether the file was already opened or not
			Document existingDoc = Utl.FindDocumentByPath( _Documents, filePath );

			// save as the specified file
			ok = SaveDocument( ActiveDocument, filePath, encoding, withBom, eolCode );
			if( !ok )
			{
				return false;
			}

			// manage documents
			if( existingDoc == ActiveDocument )
			{
				// the file was saved as the file itself (overwritten.)
				// so we have no tasks to do here; just refresh UI.
				_MainForm.ResetText();
				_MainForm.TabControl.Refresh();
			}
			else if( existingDoc != null )
			{
				// target file was already opened in other tab (the existing file was not overwritten).
				// so close this window, activate the existing one, and reflesh
				CloseDocument();
				DocViewMan_Activate( existingDoc );
				Form_Activated( this, EventArgs.Empty ); // simulate activation event
			}
			else
			{
				// the file was saved as a file that was not opened yet.

				// judge file type
				ActiveDocument.FileType = FileTypeRepository.GetByFilePath( filePath );

				// update UI
				DocViewMan_UpdateUI( ActiveDocument );
			}
			
			return true;
		}

		/// <summary>
		/// ނۑ܂B
		/// </summary>
		/// <returns>[ULZuȂvǂB</returns>
		bool SaveDocument( Document doc, string filePath, Encoding encoding, bool withBom, EolCode eolCode )
		{
			Debug.Assert( doc != null );
			Debug.Assert( filePath != null );
			Debug.Assert( encoding != null );

			FileAttributes attr;

			// ͂Ƃۑ݂
			try
			{
				doc.Save( filePath, encoding, withBom, eolCode );
			}
			catch( UnauthorizedAccessException ex )
			{
				// ǂݎpt@C䂦̎sȂp̃bZ[Wo
				try
				{
					attr = File.GetAttributes( filePath );
					if( (attr & FileAttributes.ReadOnly) != 0 )
					{
						Utl.AlertFailedToSaveFile_ReadOnly( _MainForm, filePath );
						return false;
					}
				}
				catch
				{}

				// ȂΕʂɕۑsbZ[W\
				Utl.AlertFailedToSaveFile( _MainForm, ex );
				return false;
			}
			catch( SecurityException ex )
			{
				Utl.AlertFailedToSaveFile( _MainForm, ex );
				return false;
			}
			catch( IOException ex )
			{
				Utl.AlertFailedToSaveFile( _MainForm, ex );
				return false;
			}

			// MRU ۑ
			AppConfig.AddMru( doc );

			// Dirty tO낷
			doc.Editor.IsDirty = false;

			return true;
		}
		#endregion

		#region Reload
		/// <summary>
		/// ̑Ńt@CǂݒB
		/// GR[fBO͍Đ肷B
		/// </summary>
		/// <returns>ǂݒɐǂ</returns>
		public bool ReloadDocument( Document doc )
		{
			return ReloadDocument( doc, null, false );
		}

		/// <summary>
		/// ̑Ńt@Cǂݒ
		/// </summary>
		/// <param name="encoding">ǂݒ̂ɎgGR[fBO</param>
		/// <returns>ǂݒɐǂ</returns>
		public bool ReloadDocument( Document doc, Encoding encoding, bool withBom )
		{
			// xۑĂȂVKt@CȂΉ邱Ƃ͂Ȃ
			if( doc.Path == null )
			{
				Win32.MessageBeep_Notify();
				return false;
			}

			// ۑĂȂꍇ͓ǂݒėǂq˂
			if( doc.IsModified )
			{
				DialogResult result = ConfirmDiscardChanges();
				if( result != DialogResult.Yes )
				{
					return false;
				}

				// Dirty tO낷
				doc.Editor.IsDirty = false;
			}

			// [h
			try
			{
				doc.Reload( encoding, withBom );
			}
			catch( IOException ex )
			{
				Utl.AlertFailedToOpenFile( _MainForm, Path.GetFileName(doc.Path), ex );
				CloseDocument( doc );
				return false;
			}
			catch( UnauthorizedAccessException ex )
			{
				Utl.AlertFailedToOpenFile( _MainForm, Path.GetFileName(doc.Path), ex );
				CloseDocument( doc );
				return false;
			}

			// UI XV
			_MainForm.ResetText();
			_MainForm.TabControl.Refresh();

			return true;
		}
		#endregion

		#region Export
		/// <summary>
		/// ݃ANeBuȃhLg̑I͈͂GNX|[g܂B
		/// </summary>
		public void ExportDocument()
		{
			ExportFileDialog dialog;
			DialogResult result;
			string content;

			// BrailleConverter.dll pł邩mF
			if( BrlCvt.Installed == false )
			{
				NbsMessageBox.Show(
						MainForm,
						_Msg_BrailleConverterNotInstalled,
						MessageBoxButtons.OK,
						MessageBoxIcon.Warning
					);
				return;
			}
			if( BrlCvt.Initialized == false )
			{
				NbsMessageBox.Show(
						MainForm,
						_Msg_BrailleConverterFailedToInitialized,
						MessageBoxButtons.OK,
						MessageBoxIcon.Warning
					);
				return;
			}

			// GNX|[gΏۂ̃eLXg擾
			content = ActiveDocument.Editor.SelectedText;
			if( content == String.Empty )
			{
				content = ActiveDocument.Editor.GetText( EolCode.CRLF );
				if( content == String.Empty )
				{
					NbsMessageBox.Show( _Msg_NoCharactersToExport );
					return;
				}
			}

			using( dialog = new ExportFileDialog() )
			{
				// _CAO
				dialog.StartPosition = FormStartPosition.CenterParent;
				if( ActiveDocument != null )
				{
					// set initial value from the active document
					if( File.Exists(ActiveDocument.Path) )
					{
						dialog.InitialDirectory = Path.GetDirectoryName( ActiveDocument.Path );
					}
					dialog.FileName = ActiveDocument.FileName;
				}

				// GNX|[gƐݒ[Uɐq˂
				result = dialog.ShowDialog( MainForm );
				if( result != DialogResult.OK )
				{
					return;
				}

				// GNX|[gs
				ExportDocument(
						content,
						dialog.FileName,
						dialog.FileFormat,
						dialog.ConversionParam
					);
			}
		}

		void ExportDocument(
				string content,
				string outputPath,
				FileFormat outputFormat,
				BrlCvtParam convParam
			)
		{
			Debug.Assert( outputPath != null );

			try
			{
				// ꎞt@Cɏo
				File.WriteAllText(
						AppConfig.ExportTempFilePath,
						content,
						Encoding.GetEncoding("Shift_JIS")
					);

				// t@Ctot@Cŕϊs
				BrlCvt.ConvertFromKanji(
						AppConfig.ExportTempFilePath,
						outputPath,
						outputFormat,
						convParam
					);
			}
			catch( Exception ex )
			{
				NbsMessageBox.Show(
					MainForm, ex.Message, MessageBoxButtons.OK, MessageBoxIcon.Error
				);
			}
		}
		#endregion

		#region Utilities
		partial class Utl
		{
			/// <summary>
			/// t@CJȂ[Uɒʒm܂B
			/// </summary>
			/// <param name="ex">JɔOB</param>
			public static void AlertFailedToOpenFile( AiBEditForm form, string filePath, Exception ex )
			{
				string format = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_FailedToOpenFile", "Failed to open file \"{0}\". {1}" );
				NbsMessageBox.Show( form, String.Format(format, filePath, ex.Message), MessageBoxButtons.OK, MessageBoxIcon.Error );
			}

			/// <summary>
			/// ݐ悪ǂݎpt@C߂
			/// t@CۑłȂ[Uɒʒm܂B
			/// </summary>
			/// <param name="ex">ۑɔOB</param>
			public static void AlertFailedToSaveFile_ReadOnly( AiBEditForm form, string fileName )
			{
				string format = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_CannotWriteToReadonlyFile", "Cannot write into a read only file. {0} is readonly." );
				NbsMessageBox.Show( form, String.Format(format, fileName) );
			}

			/// <summary>
			/// t@CۑłȂ[Uɒʒm܂B
			/// </summary>
			/// <param name="ex">ۑɔOB</param>
			public static void AlertFailedToSaveFile( AiBEditForm form, Exception ex )
			{
				string format = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_FailedToSaveFile", "Failed to save file. {0}" );
				NbsMessageBox.Show( form, String.Format(format, ex.Message) );
			}

			/// <summary>
			/// ۑ̃hLgۑ邩q˂_CAO\܂B
			/// </summary>
			public static DialogResult AskToSaveDocument( AiBEditForm form, Document doc )
			{
				string	message;

				// ₢킹bZ[W̕ʂ𐶐
				string format = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_NotSavedYet",
						"{0} has been modified. Save before close?"
					);
				message = String.Format( format, doc.DisplayName );
				
				// ₢킹
				return NbsMessageBox.Show( form, message, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Information );
			}

			/// <summary>
			/// pXŃhLg
			/// </summary>
			public static Document FindDocumentByPath( List<Document> docs, string filePath )
			{
				foreach( Document doc in docs )
				{
					if( doc.Path == filePath )
					{
						return doc;
					}
				}

				return null;
			}

/*
/// <summary>
/// hLgVK쐬ׂB
/// </summary>
public static bool IsReusable( Document activeDoc )
{
	// JĂȂ
	if( activeDoc == null )
		return true;

	// VKt@CłȂꍇ
	if( activeDoc.Path != null )
		return true;

	// VKt@CύXĂꍇ
	if( activeDoc.Path == null && activeDoc.IsModified )
		return true;

	return false;
}*/

			/// <summary>
			/// t@CVXe琳mȃpXĎ擾B
			/// </summary>
			/// <param name="filePath">mȃpXĎ擾t@C̃pX</param>
			/// <returns>Ď擾pX</returns>
			/// <remarks>
			/// Windows ł͑啶ʂƕsȃpXłgĂ܂B
			/// 啶̕ʂmɎ擾邽߂ɌĂԁB
			/// </remarks>
			/// <exception cref="System.IO.IOException">I/OG[</exception>
			public static string ReGetFilePath( string filePath )
			{
				Debug.Assert( filePath != null );
				Debug.Assert( Path.IsPathRooted(filePath) );

				string dir, filter;

				// ݂Ȃꍇ͂̂܂
				if( File.Exists(filePath) == false )
				{
					return filePath;
				}

				dir = Path.GetDirectoryName( filePath );
				dir = Path.GetFullPath( dir );
				filter = Path.GetFileName( filePath );
				return Directory.GetFiles( dir, filter )[0];
			}
		}
		#endregion
	}
}
