// file: AppLogic.DocViewMan.cs
// brief: logic to manage Document and View.
// update: 2009-05-05
//=========================================================
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Debug = System.Diagnostics.Debug;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	partial class AppLogic
	{
		#region hLg
		/// <summary>
		/// hLgǗΏۂɒǉ܂B
		/// </summary>
		void DocViewMan_Add( Document doc )
		{
			MyMenuItem mi = new MyMenuItem();
			int windowCount;

			// Window j[ɍڂǉ
			windowCount = _MainForm.WindowMenu.MenuItems.Count;
			mi.Tag = doc;
			mi.Click += DocMenu_Click;
			mi.Text = String.Format( "&{0} {1}", windowCount-4, doc.ToString() );
			_MainForm.WindowMenu.MenuItems.Add( mi );

			// ^uRg[֓o^
			_MainForm.TabControl.Add( doc );
			_MainForm.TabControl.Select( doc );

			// _\Ɠǂݏグ̑Ώۂɓo^
			if( doc.Editor is AzukiEdit )
			{
				_AzukiEditReader.Add( (AzukiEdit)doc.Editor );
			}
			TextEditorBrailler.Inst.Add( doc.Editor );

			// CtH[̎qEBhEƂēo^
			Control editor = (Control)doc.Editor;
			_MainForm.TextBoxPanel.Controls.Add( editor );
			if( _Documents.Count == 1 ) // ɂ͐Ȃ
			{
				// 0  1 ֕ωꍇ͕ҏWj[ȂǂL
				_MainForm.EnableEditMenuItems( true );
				_MainForm.EnableWindowSwitchMenuItems( true );
				_MainForm.EnableReloadMenuItem( !doc.IsNewFile );
			}

			// ̑ݒ
			editor.Dock = DockStyle.Fill;
            editor.KeyUp += DocViewMon_Control_KeyUp;
			doc.Editor.DirtyStateChanged += Document_DirtyStateChanged;
			_Documents.Insert( 0, doc );

			// VKǉȊOɂʂ UI ڂXV
			DocViewMan_UpdateUI( doc );
		}

		/// <summary>
		/// hLg̏Ԃɉ UI XV܂B
		/// </summary>
		void DocViewMan_UpdateUI( Document doc )
		{
			Debug.Assert( doc != null, "argument null" );

			MyMenuItem mi;

			// Window j[̕\XV
			mi = Utl.FindWindowMenuItem( _MainForm, doc );
			Debug.Assert( mi != null, "No menu item exists which is associated with given doc." );
			mi.Text = mi.Text.Substring( 0, 3 ) + doc.ToString();

			// ^uRg[ĕ`
			_MainForm.TabControl.Invalidate();

			// CtH[XV
			_MainForm.ResetText();
			if( _Documents.Count == 1 ) // ɂ͐Ȃ
			{
				// 0  1 ֕ω̂ŕҏWj[ȂǂL
				_MainForm.EnableEditMenuItems( true );
				_MainForm.EnableWindowSwitchMenuItems( true );
				_MainForm.EnableReloadMenuItem( !doc.IsNewFile );
			}
		}

		/// <summary>
		/// hLgǗΏۂ폜܂B
		/// </summary>
		void DocViewMon_Remove( Document doc )
		{
			// tH[̎qEBhE폜
			Control textBox = (Control)doc.Editor;
			textBox.Enabled = false;
			_MainForm.Controls.Remove( textBox );

			// Window j[폜
			Utl.RemoveDocumentFromWindowMenu( _MainForm, doc );

			// ^uRg[폜
			_MainForm.TabControl.Remove( doc );

			// _\Aǂݏグ̑Ώۂ폜
			if( doc.Editor is AzukiEdit )
			{
				_AzukiEditReader.Remove( (AzukiEdit)doc.Editor );
			}
			TextEditorBrailler.Inst.Remove( doc.Editor );

			// ̑ݒ
			doc.Editor.DirtyStateChanged -= Document_DirtyStateChanged;
			_Documents.Remove( doc );
		}

		void DocViewMon_Control_KeyUp( object sender, KeyEventArgs e )
		{
			if( e.KeyData == Keys.Insert )
			{
				AutoSpeaker.Instance.Stop();
				if( ActiveDocument.IsOverwriteMode )
				{
					AutoSpeaker.Instance.Speak( _Msg_OverwriteModeOff );
				}
				else
				{
					AutoSpeaker.Instance.Speak( _Msg_OverwriteModeOn );
				}
			}
		}
		#endregion

		#region AvS
		/// <summary>
		/// hLgGfB^ł̕ҏWΏۂɂ܂B
		/// </summary>
		public void DocViewMan_Activate( Document doc )
		{
			Debug.Assert( doc != null );
			Debug.Assert( doc.Editor != null, "a disposed document was given." );

			Document prevActiveDocument = _ActiveDocument;
			MenuItem mi;

			if( doc == ActiveDocument )
				return;

			NbsEngine.Instance.BeginUpdate();

			_ActiveDocument = doc;

			// ANeBuɂȂނ̃EBhE\
			doc.Editor.Show();
			doc.Editor.Select();
			doc.Editor.Focus();
			if( prevActiveDocument != null )
			{
				// OɃANeBuhLg\
				Debug.Assert( prevActiveDocument.Editor != null, "prevActiveDocument.Editor is null!" );
				prevActiveDocument.Editor.Hide();
				mi = Utl.FindWindowMenuItem( _MainForm, prevActiveDocument );
				if( mi != null )
				{
					mi.Checked = false;
				}
			}

			// ^uI
			Debug.Assert( _MainForm.TabControl.Contains(doc) );
			_MainForm.TabControl.Select( doc );
			_MainForm.TabControl.Invalidate();

			// CtH[ UI XV
			_MainForm.ResetText();
			Utl.FindWindowMenuItem( _MainForm, doc ).Checked = true;
			_MainForm.EnableReloadMenuItem( (doc.Path != null) );
			UpdateEditModeMenu();
			UpdateMruFileMenu();

			NbsEngine.Instance.EndUpdate();
		}
		#endregion
	}
}
