// file: AppConfig.cs
// brief: application configuration manager
// update: 2011-01-30
//=========================================================
using System;
using System.Drawing;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.IO;
using Debug = System.Diagnostics.Debug;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	/// <summary>
	/// AvP[VŜ̐ݒǗÓINXB
	/// </summary>
	static class AppConfig
	{
		#region Fields
		static string _ConfigFilePath;
		static string _MruFilePath;
		static Ini _Mru = new Ini();
		
		/// <summary>
		/// @ݒB
		/// </summary>
		public static DeviceConfig DeviceConfig;

		/// <summary>
		/// _\ݒB
		/// </summary>
		public static BrailleConfig BrailleConfig;
		
		/// <summary>
		/// gpeLXgGfB^ GW
		/// </summary>
		public static string EngineType;

		/// <summary>
		/// Home L[ōsł͂Ȃŏ̔󔒕ɃLbgړ邩ǂ
		/// </summary>
		public static bool UseSmartHome;

		/// <summary>
		/// _\sǂB
		/// </summary>
		public static bool UsingBraille;

		/// <summary>
		/// B
		/// </summary>
		public static FindCondition FindCondition = new FindCondition();
		
		/// <summary>
		/// Cfg[hB
		/// </summary>
		public static AutoIndentMode AutoIndentMode;

		/// <summary>
		/// CEBhEő剻Ă邩ǂB
		/// </summary>
		public static bool WindowMaximized;

		/// <summary>
		/// CEBhËʒuB
		/// </summary>
		public static Point WindowLocation = new Point();

		/// <summary>
		/// CEBhẼTCYB
		/// </summary>
		public static Size WindowSize = new Size();

		/// <summary>
		/// Azuki ̃IvV擾܂͐ݒ肵܂B
		/// </summary>
		public static AzukiOption AzukiOption = AzukiOption.Default;

		public static Dictionary<FileFormat, BrlCvtParam>
			BrlCvtParams = new Dictionary<FileFormat,BrlCvtParam>( 4 );
		#endregion

		#region Init / Dispose
		/// <summary>
		/// NX
		/// </summary>
		public static void Init()
		{
			// ensure that the MRU(Most Recent Used) data file exists
			if( File.Exists(MruFilePath) == false )
			{
				Directory.CreateDirectory( ConfigDirectoryPath );
				File.WriteAllText( MruFilePath, String.Empty ); // create
			}

			// but if the file size is larger than 1MB, it may be corrupted
			FileInfo f = new FileInfo( MruFilePath );
			if( 1000000 < f.Length )
			{
				File.Delete( MruFilePath ); // corrupted so delete that file
			}

			// MRU f[^[h
			_Mru.Load( MruFilePath, Encoding.UTF8 );

			// ꎞt@C΍폜Ă
			if( File.Exists(AppConfig.ExportTempFilePath) )
			{
				try
				{
					File.Delete( AppConfig.ExportTempFilePath );
				}
				catch
				{}
			}
		}
		#endregion

		#region t@CpX֘ÃvpeB
		/// <summary>
		/// AvP[V̐ݒzufBNgpX擾܂B
		/// </summary>
		public static string ConfigDirectoryPath
		{
			get
			{
				string path;
				
				path = Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData );
				path = Path.Combine( path, "AiBTools3" );
				path = Path.Combine( path, "AiBEdit" );

				return path;
			}
		}

		/// <summary>
		/// ݒt@C̃pX
		/// </summary>
		public static string ConfigFilePath
		{
			get
			{
				if( _ConfigFilePath == null )
				{
					_ConfigFilePath = Path.Combine( ConfigDirectoryPath, "AiBEdit.ini" );
				}

				return _ConfigFilePath;
			}
		}

		/// <summary>
		/// MRU t@C̃pX
		/// </summary>
		public static string MruFilePath
		{
			get
			{
				if( _MruFilePath == null )
				{
					_MruFilePath = Path.Combine( ConfigDirectoryPath, "MRU.ini" );
				}

				return _MruFilePath;
			}
		}

		/// <summary>
		/// GNX|[gpꎞt@C̃pX
		/// </summary>
		public static string ExportTempFilePath
		{
			get
			{
				return Path.Combine( ConfigDirectoryPath, "ExportTemp.txt" );
			}
		}

		/// <summary>
		/// GNX|[gpOt@C̃pX
		/// </summary>
		public static string ExportLogFilePath
		{
			get
			{
				return Path.Combine( ConfigDirectoryPath, "Export.log" );
			}
		}
		#endregion

		#region MRU
		/// <summary>
		/// uŋߎgt@CṽpX 17 擾
		/// </summary>
		public static string[] Get17MruFilePaths()
		{
			List<string> paths = new List<string>( 17 );
			Ini.Section mruSection;
			bool found;

			// read MRU section
			found = _Mru.Sections.TryGetValue( "MRU", out mruSection );
			if( !found )
			{
				return paths.ToArray();
			}

			foreach( KeyValuePair<string, string> item in mruSection )
			{
				// get this MRU data and validate
				string path = item.Value;
				if( 256 < path.Length )
				{
					// this path may be corrupted...
					mruSection.Remove( item.Key );
					_Mru.Sections.Remove( path );
					continue;
				}
				else if( 128 < path.Length )
				{
					int defEncLen = Encoding.Default.GetByteCount( path );
					if( 256 < defEncLen )
					{
						mruSection.Remove( item.Key );
						_Mru.Sections.Remove( path );
						continue;
					}
				}

				// keep this data and go next data
				paths.Add( path );
				if( 0x0f < paths.Count )
				{
					break;
				}
			}

			return paths.ToArray();
		}

		/// <summary>
		/// MRU ꗗɏނށB
		/// </summary>
		public static void AddMru( Document doc )
		{
			Debug.Assert( doc.Path != null, "Document not associated with a file was given." );
			Debug.Assert( Path.IsPathRooted(doc.Path), "Document associated with non-full-path was given." );

			try
			{
				AddToMruSection( doc.Path );
				AddToMruHistory( doc );
			}
			catch( IOException )
			{}
		}

		/// <summary>
		/// wt@C MRU Ńp^tH[obN܂B
		/// </summary>
		/// <param name="filePath">MRU 擾t@C̃pX</param>
		/// <param name="encoding">OҏW̃GR[fBO</param>
		/// <param name="withBom">OҏW BOM R[hL</param>
		/// <param name="caretLine">OҏW̃Lbgsʒu</param>
		/// <param name="caretColumn">OҏW̃Lbgʒu</param>
		public static void GetMruFileInfo(
				string filePath, ref Encoding encoding,
				ref bool withBom, ref int caretLine, ref int caretColumn
			)
		{
			Debug.Assert( Path.IsPathRooted(filePath) );

			string encodingName;

			encoding = null;
			withBom = _Mru.Get( filePath, "WithBom", false );
			caretLine = _Mru.Get( filePath, "CaretLine", 0 );
			caretColumn = _Mru.Get( filePath, "CaretColumn", 0 );

			// GR[fBO MRU 擾
			encodingName = _Mru.Get( filePath, "Encoding", null );
			if( encodingName != null )
			{
				try
				{
					encoding = Encoding.GetEncoding( encodingName );
				}
				catch( ArgumentException )
				{}
			}

			// GR[fBO MRU 擾łȂꍇ͐
			if( encoding == null )
			{
				try
				{
					encoding = EncodingAnalyzer.Analyze( filePath, out withBom );
				}
				catch
				{
					encoding = Encoding.Default;
				}
			}
		}

		/// <summary>
		/// MRU.ini  MRU ZNVɎwt@CpXǉ
		/// </summary>
		/// <exception cref="IOException">t@Co̓G[</exception>
		static void AddToMruSection( string filePath )
		{
			const int maxMruCount = 50;
			int mruNo;
			StringCollection newMru = new StringCollection();
			Ini.Section mruSection;
			bool found;

			// get MRU section
			found = _Mru.Sections.TryGetValue( "MRU", out mruSection );
			if( !found )
			{
				// this is the first time. just create an entry
				_Mru.Set("MRU", "MRU00", filePath );
				return;
			}
			
			// make list of 50 MRU info
			newMru.Add( filePath );
			for( mruNo=0; mruNo < mruSection.Count && mruNo < maxMruCount; mruNo++ )
			{
				string entryName = mruSection[ "MRU" + mruNo.ToString("D2") ];
				if( String.Compare(entryName, filePath, true) != 0
					&& Path.IsPathRooted(entryName) )
				{
					newMru.Add( entryName );
				}
			}

			// if there are left MRU data, remove it from INI to save file size
			for( ; mruNo<mruSection.Count; mruNo++ )
			{
				string entryName = mruSection[ "MRU" + mruNo.ToString("D2") ];
				mruSection.Remove( "MRU" + mruNo.ToString("D2") );
				_Mru.Sections.Remove( entryName );
			}

			// update INI object
			for( mruNo=0; mruNo<newMru.Count; mruNo++ )
			{
				mruSection[ "MRU" + mruNo.ToString("D2") ] = newMru[ mruNo ];
			}

			// then overwrite the INI file
			_Mru.Save( MruFilePath, Encoding.UTF8, "\r\n" );
		}

		static void AddToMruHistory( Document doc )
		{
			int line, column;
			
			// write the document information
			doc.GetCaretIndex( out line, out column );
			_Mru.Set( doc.Path, "Encoding", doc.Encoding.WebName );
			_Mru.Set( doc.Path, "WithBom", doc.WithBom );
			_Mru.Set( doc.Path, "CaretLine", line );
			_Mru.Set( doc.Path, "CaretColumn", column );
			_Mru.Set( doc.Path, "Bookmarks", " " );
			
			// update INI file
			_Mru.Save( MruFilePath, Encoding.UTF8, "\r\n" );
		}
		#endregion

		#region Load / Save
		/// <summary>
		/// AvP[V̐ݒۑ
		/// </summary>
		public static void SaveConfig()
		{
			Ini	ini = new Ini();

			// store config
			ini.Set( "AiBEdit", "UseBrailleDisplay", UsingBraille );
			ini.Set( "AiBEdit", "FindCondition.IgnoreCase", FindCondition.IgnoreCase );
			ini.Set( "AiBEdit", "FindCondition.UseRegex", FindCondition.UseRegex );
			ini.Set( "AiBEdit", "TextEditorEngine", EngineType );
			ini.Set( "AiBEdit", "UseSmartHome", UseSmartHome );
			ini.Set( "AiBEdit", "AutoIndentMode", (int)AutoIndentMode );
			ini.Set( "AiBEdit", "WindowMaximized", WindowMaximized );
			ini.Set( "AiBEdit", "WindowX", WindowLocation.X );
			ini.Set( "AiBEdit", "WindowY", WindowLocation.Y );
			ini.Set( "AiBEdit", "WindowWidth", WindowSize.Width );
			ini.Set( "AiBEdit", "WindowHeight", WindowSize.Height );
			ini.Set( "AiBEdit", "AzukiOption.SpeaksLineFromCaret", AzukiOption.SpeaksLineFromCaret );
			ini.Set( "AiBEdit", "AzukiOption.SpeaksChangedPartOnSelect", AzukiOption.SpeaksChangedPartOnSelect );
			ini.Set( "AiBEdit", "AzukiOption.ConvertsTab", AzukiOption.ConvertsTabToSpaces );
			ini.Set( "AiBEdit", "AzukiOption.ConvertsFullWidthSpace", AzukiOption.ConvertsFullWidthSpaceToSpaces );
			ini.Set( "AiBEdit", "AzukiOption.HighlightsCurrentLine", AzukiOption.HighlightsCurrentLine );
			ini.Set( "AiBEdit", "AzukiOption.ShowsLineNumber", AzukiOption.ShowsLineNumber );
			ini.Set( "AiBEdit", "AzukiOption.TabWidth", AzukiOption.TabWidth );

			BrailleConfig.Serialize( ini );
			DeviceConfig.Serialize( ini );
			BrlCvtParams[FileFormat.EX_NABCC].Serialize( ini, "BrlCvtParam_EX_NABCC" );
			BrlCvtParams[FileFormat.BS3].Serialize( ini, "BrlCvtParam_BS3" );
			BrlCvtParams[FileFormat.BASE].Serialize( ini, "BrlCvtParam_BASE" );
			BrlCvtParams[FileFormat.BES].Serialize( ini, "BrlCvtParam_BES" );

			// save to file
			ini.Save( ConfigFilePath, Encoding.UTF8, "\r\n" );
		}

		/// <summary>
		/// AvP[V̐ݒݒt@Cǂݏo܂B
		/// </summary>
		public static void LoadConfig()
		{
			Ini	ini = new Ini();

			// load config file
			try
			{
				ini.Load( ConfigFilePath, Encoding.UTF8 );
			}
			catch( FileNotFoundException )
			{}

			// read config
			UsingBraille = ini.Get( "AiBEdit", "UseBrailleDisplay", false );
			FindCondition.IgnoreCase = ini.Get( "AiBEdit", "FindCondition.IgnoreCase", false );
			EngineType = ini.Get( "AiBEdit", "TextEditorEngine", "RichEdit" );
			UseSmartHome = ini.Get( "AiBEdit", "UseSmartHome", false );
			AutoIndentMode = ini.Get( "AiBEdit", "AutoIndentMode", AutoIndentMode.None );
			WindowMaximized = ini.Get( "AiBEdit", "WindowMaximized", true );
			WindowLocation.X = ini.Get( "AiBEdit", "WindowX", 0 );
			WindowLocation.Y = ini.Get( "AiBEdit", "WindowY", 0 );
			WindowSize.Width = ini.Get( "AiBEdit", "WindowWidth", 640 );
			WindowSize.Height = ini.Get( "AiBEdit", "WindowHeight", 480 );
			bool useRegex = ini.Get( "AiBEdit", "FindCondition.UseRegex", false );
			if( useRegex )
			{
				FindCondition.Regex = new Regex( "" );
			}
			AzukiOption.SpeaksLineFromCaret = ini.Get( "AiBEdit", "AzukiOption.SpeaksLineFromCaret", true );
			AzukiOption.SpeaksChangedPartOnSelect = ini.Get( "AiBEdit", "AzukiOption.SpeaksChangedPartOnSelect", true );
			AzukiOption.ConvertsTabToSpaces = ini.Get( "AiBEdit", "AzukiOption.ConvertsTab", false );
			AzukiOption.ConvertsFullWidthSpaceToSpaces = ini.Get( "AiBEdit", "AzukiOption.ConvertsFullWidthSpace", false );
			AzukiOption.HighlightsCurrentLine = ini.Get( "AiBEdit", "AzukiOption.HighlightsCurrentLine", true );
			AzukiOption.ShowsLineNumber = ini.Get( "AiBEdit", "AzukiOption.ShowsLineNumber", false );
			AzukiOption.TabWidth = ini.Get( "AiBEdit", "AzukiOption.TabWidth", 4 );
			
			BrailleConfig = BrailleConfig.Deserialize( ini );
			DeviceConfig = DeviceConfig.Deserialize( ini );
			BrlCvtParams[FileFormat.EX_NABCC] = BrlCvtParam.Deserialize( ini, "BrlCvtParam_EX_NABCC" );
			BrlCvtParams[FileFormat.BS3] = BrlCvtParam.Deserialize( ini, "BrlCvtParam_BS3" );
			BrlCvtParams[FileFormat.BASE] = BrlCvtParam.Deserialize( ini, "BrlCvtParam_BASE" );
			BrlCvtParams[FileFormat.BES] = BrlCvtParam.Deserialize( ini, "BrlCvtParam_BES" );
		}
		#endregion
	}
}
