// file: AiBTabControl.cs
// brief: simple tab control
// update: 2008-09-27
//=========================================================
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace Sgry.AiBTools.AiBEdit
{
	/// <summary>
	/// ƎɎ蔲^uۂRg[
	/// </summary>
	public class AiBTabControl<T> : Panel
	{
		#region Fields
		List<T> _Items = new List<T>();
		List<float> _RightCoords = new List<float>();
		Brush _Brush_Text, _Brush_Back, _Brush_Active;
		Pen _Pen;
		T _SelectedItem;
		#endregion

		#region Init / Dispose
		/// <summary>
		/// VCX^X𐶐
		/// </summary>
		public AiBTabControl()
		{
			ControlStyles style = ControlStyles.ResizeRedraw
				| ControlStyles.AllPaintingInWmPaint
				| ControlStyles.OptimizedDoubleBuffer;
			
			SetStyle( style, true );
			
			_Brush_Text = new SolidBrush( Color.FromKnownColor(KnownColor.WindowText) );
			_Brush_Back = new SolidBrush( Color.FromKnownColor(KnownColor.Control) );
			_Brush_Active = new SolidBrush( Color.FromKnownColor(KnownColor.Window) );
			_Pen = new Pen( Color.FromKnownColor(KnownColor.GrayText) );
		}
		
		/// <summary>
		/// \[X܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				_Brush_Text.Dispose();
				_Brush_Back.Dispose();
				_Brush_Active.Dispose();
				_Pen.Dispose();
			}
			base.Dispose( disposing );
		}
		#endregion

		#region ^ȗ
		/// <summary>
		/// IĂ^uڂ擾B
		/// </summary>
		public object SelectedItem
		{
			get{ return _SelectedItem; }
		}

		/// <summary>
		/// w肵f[^Ɋ֘Atꂽ^u邩mFB
		/// </summary>
		public bool Contains( T tag )
		{
			Debug.Assert( tag != null );

			return _Items.Contains( tag );
		}

		/// <summary>
		/// w肵f[^Ɋ֘Atꂽ^uI
		/// </summary>
		public void Select( T tag )
		{
			int index = _Items.IndexOf( tag );
			if( index == -1 )
			{
				Debug.Fail( "there is no tab associated with given object." );
				return;
			}

			_SelectedItem = tag;
			Refresh();
		}

		/// <summary>
		/// ̃^uI
		/// </summary>
		public void SelectNextTab()
		{
			if( _Items.Count == 0 )
				return;

			// Iׂ^ũCfbNXvZ
			int index = _Items.IndexOf( _SelectedItem );
			if( index+1 < _Items.Count )
				index++;
			else
				index = 0;
			_SelectedItem = _Items[index];

			// ^uICxg𔭐
			if( TabClicked != null )
			{
				TabClicked( MouseButtons.Left, index, _SelectedItem );
			}
		}

		/// <summary>
		/// Õ^uI
		/// </summary>
		public void SelectPreviousTab()
		{
			if( _Items.Count == 0 )
				return;

			// Iׂ^ũCfbNXvZ
			int index = _Items.IndexOf( _SelectedItem );
			if( 0 < index )
				index--;
			else
				index = _Items.Count - 1;
			_SelectedItem = _Items[index];

			// ^uICxg𔭐
			if( TabClicked != null )
			{
				TabClicked( MouseButtons.Left, index, _SelectedItem );
			}
		}

		/// <summary>
		/// ^uǉ
		/// </summary>
		/// <param name="item">ǉ^uɊ֘AtCӂ̃f[^</param>
		public void Add( T item )
		{
			_Items.Add( item );
			_RightCoords.Add( 0.0f );
			Refresh();
		}

		/// <summary>
		/// ^u폜
		/// </summary>
		/// <param name="tag">폜^uɊ֘AtCӂ̃f[^</param>
		public void Remove( T tag )
		{
			// wIuWFNgč폜
			int index = _Items.IndexOf( tag );
			if( index != -1 )
			{
				_Items.RemoveAt( index );
				_RightCoords.RemoveAt( index );
				Refresh();
			}

			// ܂I𒆃^uɊ֘AtĂ̂łΑI
			if( tag.Equals(_SelectedItem) )
			{
				_SelectedItem = default(T);
			}
		}
		#endregion

		#region JCxg
		/// <summary>
		/// ^uNbNꂽɔ܂B
		/// </summary>
		public event TabClickedEventHandler TabClicked;
		
		/// <summary>
		/// ^uNbNꂽCxgɔfQ[g
		/// </summary>
		/// <param name="button">NbNɎgꂽ{^</param>
		/// <param name="index">NbNꂽ^ũCfbNX</param>
		/// <param name="tag">NbNꂽ^uɊ֘Atꂽ^O</param>
		public delegate void TabClickedEventHandler( MouseButtons button, int index, object tag );
		#endregion

		#region `
		protected override void OnPaintBackground( PaintEventArgs e )
		{
			base.OnPaintBackground( e );

			e.Graphics.FillRectangle( _Brush_Back, 0, 0, Width, Height );
			e.Graphics.DrawLine( _Pen, 0, Height-1, Width, Height-1 );
		}

		protected override void OnPaint( PaintEventArgs e )
		{
			base.OnPaint( e );

			Graphics g = e.Graphics;
			float left = 6f;
			Size size;

			size = g.MeasureString( "X", Font ).ToSize();
			if( Height != size.Height )
			{
				Height = (int)size.Height + 5;
			}

			// ׂẴ^u`
			for( int i=0; i<_Items.Count; i++ )
			{
				string text = (string)_Items[i].ToString();
				size = g.MeasureString( text, Font ).ToSize();
				int w = size.Width;
				int h = size.Height;
				
				// Og`
				g.DrawLine( _Pen, left+1, Height-h-5, left+w+4, Height-h-5 ); // top
				g.DrawLine( _Pen, left+w+5, Height-h-4, left+w+5, Height-1 ); // right
				g.DrawLine( _Pen, left, Height-h-4, left, Height-1 ); // left
				
				// IɉĎc̗vf`
				if( _Items[i].Equals(_SelectedItem) )
				{
					g.FillRectangle( _Brush_Active, left+1, Height-h-4, w+4, h+5 );
				}

				// ^Cg`
				g.DrawString( text, Font, _Brush_Text, left+2, Height-size.Height-2 );

				_RightCoords[i] = left + w + 5;
				left += w + 5;
			}
		}
		#endregion

		#region Cxgnh
		protected override void OnMouseDown( MouseEventArgs e )
		{
			base.OnMouseDown( e );

			// NbNꂽ^uԍo
			for( int i=0; i<_RightCoords.Count; i++ )
			{
				if( e.X <= _RightCoords[i] )
				{
					// Cxg𔭐
					if( TabClicked != null )
					{
						TabClicked( e.Button, i, _Items[i] );
					}

					return;
				}
			}
		}
		#endregion
	}
}
