// file: AiBEditForm.cs
// brief: main form
//=========================================================
//#define ACCEDIT_IDE
using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using Sgry.AiBTools.Gui;

namespace Sgry.AiBTools.AiBEdit
{
	class AiBEditForm : Form
	{
		#region Constants
		const int WM_USER		= 0x0400;
		/// <summary>
		/// J[\ړEBhEbZ[WłB
		/// LPARAM ňړ̍sA
		/// WPARAM ňړ̌w肵܂B
		/// Pʂ͕PʂŁAOn܂̃CfbNXŎw肵܂B
		/// </summary>
		public const int AIBE_MOVECARET = WM_USER + 1;
		
		/// <summary>
		/// OvZX珑ނJ邽߂ɎgEBhEbZ[WłB
		/// ̃bZ[W󂯎vZX́A
		/// Lt@C̐擪sɂpXJ܂B
		/// ܂ LPARAMAWPARAM Ɏw肵lꂼ
		/// ړ̍sAƉ߂ďLbgʒuݒ肵܂B
		/// Pʂ͕PʂŁAOn܂̃CfbNXŎw肵܂B
		/// </summary>
		public const int AIBE_OPENFILE = WM_USER + 2;
		#endregion

		#region tB[h
		AppLogic _AppLogic;
#		if ACCEDIT_IDE
		ListViewReader _ErrorListReader;
#		endif
		Dictionary<Keys, AiBEditAction> _ActionMap = new Dictionary<Keys, AiBEditAction>();
		#endregion

		#region UI ANZX
		/// <summary>
		/// uŋߎgt@Cvj[
		/// </summary>
		public MyMenuItem MruMenu
		{
			get{ return _MI_File_Mru; }
		}

		/// <summary>
		/// uҏW[hvTuj[
		/// </summary>
		public MyMenuItem EditModeMenu
		{
			get{ return _MI_Tool_Mode; }
		}

		/// <summary>
		/// uEBhEvj[
		/// </summary>
		public MyMenuItem WindowMenu
		{
			get{ return _MI_Window; }
		}

		/// <summary>
		/// ^uRg[
		/// </summary>
		public AiBTabControl<Document> TabControl
		{
			get{ return _TabControl; }
		}

		/// <summary>
		/// eLXg{bNXzupl
		/// </summary>
		public Panel TextBoxPanel
		{
			get{ return _TextBoxPanel; }
		}

		/// <summary>
		/// _fBXvC𗘗pĂ邩ǂ\tO
		/// </summary>
		public bool UsingBraille
		{
			get{ return _MI_Braille_Use.Checked; }
			set{ _MI_Braille_Use.Checked = value; }
		}

		/// <summary>
		/// ҏW֘Ãj[ڂ̗L؂ւ
		/// </summary>
		/// <param name="enable">Lɂ邩ɂ邩w肵܂B</param>
		public void EnableEditMenuItems( bool enable )
		{
			_MI_File_Close.Enabled = _MI_File_Save.Enabled = _MI_File_SaveAs.Enabled
				= _MI_File_Reload.Enabled = _MI_Edit_Undo.Enabled
				= _MI_Edit_Cut.Enabled = _MI_Edit_Copy.Enabled = _MI_Edit_Paste.Enabled
				= _MI_Edit_Find.Enabled = _MI_Edit_FindNext.Enabled
				= _MI_Edit_FindPrevious.Enabled = _MI_Edit_SelectAll.Enabled
				= _MI_Edit_JumpToLine.Enabled = _MI_Edit_MatchedBracket.Enabled
				= _MI_Speak_CaretPos.Enabled = _MI_Speak_Line.Enabled = _MI_Speak_Selection.Enabled
				= _MI_Tool_Mode.Enabled = _MI_Tool_Outline.Enabled = _MI_Tool_Compile.Enabled
				= _MI_Tool_Build.Enabled = _MI_Tool_ErrorList.Enabled
				= enable;
		}

		public void EnableWindowSwitchMenuItems( bool enable )
		{
			_MI_Window_Next.Enabled
				= _MI_Window_Previous.Enabled
				= _MI_Window_List.Enabled
				= enable;
		}

		public void EnableReloadMenuItem( bool enable )
		{
			_MI_File_Reload.Enabled = enable;
		}
		#endregion

		#region Init / Dispose
		/// <summary>
		/// \z
		/// </summary>
		/// <param name="app">AvP[VIuWFNg</param>
		public AiBEditForm( AppLogic app )
		{
			// initialize components
			InitializeComponents();
			this.Icon = R.AppIcon;
			SetupMenuItems();
			LocalizeComponents();
			Font = SystemInformation.MenuFont;
			Location = AppConfig.WindowLocation;
			Size = AppConfig.WindowSize;
			if( AppConfig.WindowMaximized )
			{
				WindowState = FormWindowState.Maximized;
			}
			_TabControl.Font = SystemInformation.MenuFont;
			_MI_Braille_Use.Checked = AppConfig.UsingBraille;

			EnableEditMenuItems( false );
			EnableWindowSwitchMenuItems( false );

			ResetKeyBind();

			_AppLogic = app;
		}

		void ResetKeyBind()
		{
			const int VK_OEM4 = 219; // key code of '['
			const int VK_OEM6 = 221; // key code of ']'

			_ActionMap.Add( (Keys)VK_OEM4 | Keys.Control, Actions.GoToMatchedBracket );
			_ActionMap.Add( (Keys)VK_OEM6 | Keys.Control, Actions.GoToMatchedBracket );
			
			_ActionMap.Add( Keys.F6, Actions.ShowDocumentList );
			_ActionMap.Add( Keys.G | Keys.Control, Actions.GoToLine );
			_ActionMap.Add( Keys.F | Keys.Control, Actions.Find );
			_ActionMap.Add( Keys.L | Keys.Control, Actions.SpeakCaretPos );
			_ActionMap.Add( Keys.F3, Actions.FindNext );
			_ActionMap.Add( Keys.F3 | Keys.Shift, Actions.FindPrevious );
		}
		#endregion // Init / Dispose

		#region eNX̓̕ύX
		/// <summary>
		/// tH[̃LvVeLXgXV
		/// </summary>
		public override void ResetText()
		{
			StringBuilder newText = new StringBuilder();

			// AvP[Vޖ
			newText.Append( Application.ProductName );
			if( _AppLogic.ActiveDocument != null )
			{
				newText.Append( " - " );
				newText.Append( _AppLogic.ActiveDocument.ToString() );
			}
#			if DEBUG
			newText.Append( " #Debug#" );
#			endif

			// ݒ
			Text = newText.ToString();
		}
		#endregion

		#region j[R}h
		//======================================================
		// File menu
		void _MI_File_New_Click( object sender, EventArgs e )
		{
			_AppLogic.CreateUntitledDocument();
			ResetText();
		}
		void _MI_File_Open_Click( object sender, EventArgs e )
		{
			_AppLogic.OpenDocument();
		}
		void _MI_File_Save_Click( object sender, EventArgs e )
		{
			_AppLogic.SaveDocument( _AppLogic.ActiveDocument );
		}
		void _MI_File_SaveAs_Click( object sender, EventArgs e )
		{
			_AppLogic.SaveDocumentAs();
		}
		void _MI_File_Export_Click( object sender, EventArgs e )
		{
			_AppLogic.ExportDocument();
		}
		//------------------------------------------------------
		void _MI_File_Close_Click(object sender, EventArgs e)
		{
			_AppLogic.CloseDocument();
		}
		void _MI_File_Exit_Click(object sender, EventArgs e)
		{
			Win32.LockWindowUpdate( Handle );
			this.Close();
			Win32.LockWindowUpdate( IntPtr.Zero );
		}
		
		//======================================================
		// Edit menu
		void _MI_Edit_Undo_Click(object sender, EventArgs e)
		{
			_AppLogic.ActiveDocument.Editor.Undo();
		}
		//------------------------------------------------------
		void _MI_Edit_Cut_Click( object sender, EventArgs e )
		{
			_AppLogic.ActiveDocument.Editor.Cut();
		}
		void _MI_Edit_Copy_Click( object sender, EventArgs e )
		{
			_AppLogic.ActiveDocument.Editor.Copy();
		}
		void _MI_Edit_Paste_Click( object sender, EventArgs e )
		{
			_AppLogic.ActiveDocument.Editor.Paste();
		}
		//------------------------------------------------------
		void _MI_Edit_Find_Click( object sender, EventArgs e )
		{
			Actions.Find( _AppLogic );
		}
		void _MI_Edit_FindNext_Click( object sender, EventArgs e )
		{
			Actions.FindNext( _AppLogic );
		}
		void _MI_Edit_FindPrevious_Click( object sender, EventArgs e )
		{
			Actions.FindPrevious( _AppLogic );
		}
		//------------------------------------------------------
		void _MI_Edit_SelectAll_Click( object sender, EventArgs e )
		{
			_AppLogic.ActiveDocument.Editor.SelectAll();
		}
		void _MI_Edit_GoToLine_Click( object sender, EventArgs e )
		{
			Actions.GoToLine( _AppLogic );
		}
		void _MI_Edit_MatchedBracket_Click( object sender, EventArgs e )
		{
			Actions.GoToMatchedBracket( _AppLogic );
		}

		//======================================================
		// Speak menu
		void _MI_Speak_CaretPos_Click( object sender, EventArgs e )
		{
			Actions.SpeakCaretPos( _AppLogic );
		}
		void _MI_Speak_Selection_Click( object sender, EventArgs e )
		{
			Actions.SpeakSelection( _AppLogic );
		}
		void _MI_Speak_Line_Click( object sender, EventArgs e )
		{
			Actions.SpeakLine( _AppLogic );
		}

		//======================================================
		// Tool menu
		void _MI_Tool_Outline_Click( object sender, EventArgs e )
		{
			Actions.ShowOutlineDialog( _AppLogic );
		}
#if ACCEDIT_IDE
		void _MI_Tool_Compile_Click( object sender, EventArgs e )
		{
			DoCompilation( false );
		}
		void _MI_Tool_Build_Click( object sender, EventArgs e )
		{
			DoCompilation( true );
		}
		void _MI_Tool_ErrorList_Click( object sender, EventArgs e )
		{
			// IĂȂ΍ŏ̍ڂI
			if( 0 < _ErrorListView.Items.Count
				&& _ErrorListView.SelectedIndices.Count == 0 )
			{
				_ErrorListView.Items[0].Focused = true;
				_ErrorListView.Items[0].Selected = true;
			}
			_ErrorListView.Focus();
		}
#endif
		void _MI_Tool_AiBTerminal_Click( object sender, EventArgs e )
		{
			Actions.LaunchAiBTerminal( _AppLogic );
		}
		void _MI_Tool_Option_Click( object sender, EventArgs e )
		{
			_AppLogic.ShowOptionDialog();
		}

		//======================================================
		// Window menu
		void _MI_Window_Next_Click( object sender, EventArgs e )
		{
			_TabControl.SelectNextTab();
		}
		void _MI_Window_Previous_Click( object sender, EventArgs e )
		{
			_TabControl.SelectPreviousTab();
		}
		void _MI_Window_List_Click( object sender, EventArgs e )
		{
			Actions.ShowDocumentList( _AppLogic );
		}

		//======================================================
		// Braille display menu
		void _MI_Braille_Use_Click( object sender, EventArgs e )
		{
			// `FbNĂȂ΁A_fBXvC̎gpJn
			if( UsingBraille )
			{
				_AppLogic.EndUsingBraille();
			}
			else
			{
				_AppLogic.BeginUsingBraille();
			}
		}
		void _MI_Braille_DeviceConfig_Click( object sender, EventArgs e )
		{
			_AppLogic.ConfigureBrailleDevice();
		}
		void _MI_Braille_BrailleConfig_Click( object sender, EventArgs e )
		{
			_AppLogic.ConfigureBrailleSystem();
		}

		//======================================================
		// Help display menu
		void _MI_Help_Manual_Click( object sender, EventArgs e )
		{
			string path = Path.GetDirectoryName( Application.ExecutablePath );
			path = Path.Combine( path, "documents" );
			path = Path.Combine( path, "AiBEdit.txt" );
			_AppLogic.OpenDocument( path );
		}
		void _MI_Help_VersionInfo_Click( object sender, EventArgs e )
		{
			using( VersionInfoForm form = new VersionInfoForm() )
			{
				form.ShowDialog( this );
			}
		}
		#endregion // j[R}h

		#region ReLXgj[
		public void ShowSpeakMenu()
		{
			MenuItem mi;

			if( _SpeakMenu == null )
			{
				_SpeakMenu = new ContextMenu();
				mi = new MenuItem( _MI_Speak_CaretPos.Text, _MI_Speak_CaretPos_Click );
				_SpeakMenu.MenuItems.Add( mi );

				mi = new MenuItem( _MI_Speak_Selection.Text, _MI_Speak_Selection_Click );
				_SpeakMenu.MenuItems.Add( mi );
				
				mi = new MenuItem( _MI_Speak_Line.Text, _MI_Speak_Line_Click );
				_SpeakMenu.MenuItems.Add( mi );
			}

			_SpeakMenu.Show( _TextBoxPanel, System.Drawing.Point.Empty );
		}
		#endregion

		#region hbOhbv
		/// <summary>
		/// IuWFNghbOȂJ[\tH[ɓĂ̓
		/// </summary>
		void Form_DragEnter( object sender, DragEventArgs e )
		{
			object		enteringData;
			string[]	enteringFilePaths;

			// t@CifBNgj̃hbvmF
			enteringData = e.Data.GetData( DataFormats.FileDrop );
			if( enteringData == null )
			{
				return;
			}

			// hbvꂽt@C̃pX擾
			enteringFilePaths = (string[])enteringData;
			if( enteringFilePaths.Length < 1 )
			{
				return;
			}

			// fBNgȂ狑ۂ
			if( Directory.Exists(enteringFilePaths[0]) )
			{
				return;
			}

			e.Effect = DragDropEffects.Copy;
		}

		/// <summary>
		/// IuWFNghbvꂽ̓
		/// </summary>
		void Form_DragDrop( object sender, DragEventArgs e )
		{
			try
			{
				object		droppedData;
				string[]	droppedFilePaths;
				
				// hbvꂽt@CQ̃pX擾
				droppedData = e.Data.GetData( DataFormats.FileDrop );
				if( droppedData == null )
				{
					return;
				}

				droppedFilePaths = (string[])droppedData;
				if( droppedFilePaths.Length < 1 )
				{
					return;
				}

				// t@CJ
				_AppLogic.OpenDocument( droppedFilePaths[0] );
			}
			catch( Exception )
			{}
		}
		#endregion // hbOhbv

		#region EBhEbZ[W̏
		/// <summary>
		/// ǉV[gJbgL[̓`B
		/// ̃V[gJbgL[R}hA
		/// MenuItem ŎdlݒłȂL[Œ`B
		/// </summary>
		protected override bool ProcessCmdKey( ref Message msg, Keys keyData )
		{
			AiBEditAction action;
			if( _ActionMap.TryGetValue(keyData, out action) )
			{
				action( _AppLogic );
				return true;
			}

			int key = msg.WParam.ToInt32();
			if( Win32.IsControlKeyDown() )
			{
				if( (Keys)key == Keys.Tab ) // Ctrl+Tab
				{
					if( Win32.IsShiftKeyDown() )
						_MI_Window_Previous_Click( this, EventArgs.Empty );
					else
						_MI_Window_Next_Click( this, EventArgs.Empty );
					return true;
				}
				else if( (Keys)key == Keys.K )
				{
					ShowSpeakMenu();
					return true;
				}
			}
			//DEBUG-->
#			if DEBUG
			if( keyData == (Keys.Control | Keys.Cancel) ) // Ctrl+Pause (Break key)
			{
				GC.Collect();
				Win32.MessageBeep_Notify();
			}
#			endif
			//<-- DEBUG

			return base.ProcessCmdKey( ref msg, keyData );
		}

		/// <summary>
		/// WindowsbZ[WEBhEvV[W
		/// </summary>
		/// <param name="m">WindowsbZ[W</param>
		protected override void WndProc( ref Message m )
		{
			// LbgړH
			if( m.Msg == AIBE_MOVECARET )
			{
				int lineIndex = Math.Max( 0, m.WParam.ToInt32() );
				int columnIndex = Math.Max( 0, m.LParam.ToInt32() );
				
				if( _AppLogic.ActiveDocument != null )
				{
					_AppLogic.ActiveDocument.Editor.SetCaretIndex( lineIndex, columnIndex );
				}
			}
			// t@CJH
			else if( m.Msg == AIBE_OPENFILE )
			{
				string	filePath = SharedData.GetLastLine();
				int		lineIndex = Math.Max( 0, m.WParam.ToInt32() );
				int		columnIndex = Math.Max( 0, m.LParam.ToInt32() );

				if( Path.IsPathRooted(filePath) )
				{
					_AppLogic.OpenDocument( filePath );
				}
				//TODO: EBhE̐؂ւ肪Iɕɂ
				
				if( _AppLogic.ActiveDocument != null )
				{
					_AppLogic.ActiveDocument.Editor.SetCaretIndex( lineIndex, columnIndex );
				}
			}

			base.WndProc( ref m );
		}
		#endregion

		#region G[Xgr[֌W
#if ACCEDIT_IDE
		void _ErrorListView_KeyDown( object sender, KeyEventArgs e )
		{
			int focusedItemIndex;

			// GXP[vȂAeLXg{bNXɃtH[JXړ
			if( e.KeyCode == Keys.Escape )
			{
				_AppLogic.ActiveDocument.Editor.Focus();
			}

			// Xg[ŏA[ŉɈړ悤ƂAʒm
			focusedItemIndex = _ErrorListView.FocusedItem.Index;
			if( e.KeyCode == Keys.Up && focusedItemIndex == 0 )
			{
				Win32.MessageBeep_Notify();
			}
			else if( e.KeyCode == Keys.Down && focusedItemIndex == _ErrorListView.Items.Count-1 )
			{
				Win32.MessageBeep_Notify();
			}
		}

		void _ErrorListView_ItemActivate( object sender, EventArgs e )
		{
			try
			{
				int lineIndex = Int32.Parse( _ErrorListView.FocusedItem.SubItems[2].Text ) - 1;
				int hwColumnIndex = Int32.Parse( _ErrorListView.FocusedItem.SubItems[3].Text ) - 1;
				int columnIndex = Utl.CalcCharIndexFromHalfWidthIndex(
									_AppLogic.ActiveDocument.Editor.GetLineContent(lineIndex), hwColumnIndex, 8 );

				//Win32.LockWindowUpdate( _AppLogic.ActiveDocument.Editor.Handle );
				_AppLogic.ActiveDocument.Editor.Focus();
				_AppLogic.ActiveDocument.Editor.SetCaretIndex( lineIndex, columnIndex );
				//Win32.LockWindowUpdate( IntPtr.Zero );
			}
			catch( FormatException )
			{
				Win32.MessageBeep_Notify();
			}
		}
#endif
		#endregion // G[Xgr[֌W

#if ACCEDIT_IDE
		void DoCompilation( bool doBuild )
		{
			NowCompilingDialog	dialog;

			// t@CۑĂȂΕۑ
			if( _AppLogic.ActiveDocument.Path == null )
			{
				bool ok = _AppLogic.SaveDocument( _AppLogic.ActiveDocument );
				if( !ok )
				{
					return; // ۑłȂ̂ŃRpC͒~
				}
			}
			
			// RpCs
			_ErrorListView.Items.Clear();
			dialog = new NowCompilingDialog( doBuild );
			dialog.Compile( this, _AppLogic.ActiveDocument.FileType, _AppLogic.ActiveDocument );

			// RpCɐAbZ[WoăGfB^ɖ߂
			if( dialog.Result == CompileResult.Succeeded )
			{
				string message = AppLogic.Localizer.TryGetString( "Msg_SuccessfullyCompiled", "Successfully compiled." );
				NbsMessageBox.Show( this, message );
				_ErrorListView.Items.Add( _DummyListViewItem );
				_AppLogic.ActiveDocument.Editor.Focus();
			}
			// RpCG[AG[Xgr[ɃtH[JX
			else if( dialog.Result == CompileResult.CompileErrorOccured )
			{
				// RpCG[ołȂꍇ̓_~[\
				if( _ErrorListView.Items.Count == 0 )
				{
					_ErrorListView.Items.Add( _DummyListViewItem );
				}
				_MI_Tool_ErrorList_Click( this, EventArgs.Empty );
			}
			// RpC̎sɎs
			else
			{
				string message = AppLogic.Localizer.TryGetString( "Msg_FailedToExecuteCompilation", "failed to execute compilation" );
				NbsMessageBox.Show( this, message, MessageBoxButtons.OK, MessageBoxIcon.Error );
			}
		}
#endif
		#region UI Component Initialization
		/// <summary>
		/// [JCY
		/// </summary>
		void LocalizeComponents()
		{
			Localizer localizer = AppLogic.Localizer;

			localizer.TryGetString( "AiBEditForm._MI_File.Text", _MI_File );
			localizer.TryGetString( "AiBEditForm._MI_File_New.Text", _MI_File_New );
			localizer.TryGetString( "AiBEditForm._MI_File_Open.Text", _MI_File_Open );
			localizer.TryGetString( "AiBEditForm._MI_File_Save.Text", _MI_File_Save );
			localizer.TryGetString( "AiBEditForm._MI_File_SaveAs.Text", _MI_File_SaveAs );
			localizer.TryGetString( "AiBEditForm._MI_File_Reload.Text", _MI_File_Reload );
			localizer.TryGetString( "AiBEditForm._MI_File_Reload_AnalyzeAgain.Text", _MI_File_Reload_AnalyzeAgain );
			localizer.TryGetString( "AiBEditForm._MI_File_Reload_Sjis.Text", _MI_File_Reload_Sjis );
			localizer.TryGetString( "AiBEditForm._MI_File_Reload_Euc.Text", _MI_File_Reload_Euc );
			localizer.TryGetString( "AiBEditForm._MI_File_Reload_Jis.Text", _MI_File_Reload_Jis );
			localizer.TryGetString( "AiBEditForm._MI_File_Reload_Utf8.Text", _MI_File_Reload_Utf8 );
			localizer.TryGetString( "AiBEditForm._MI_File_Export.Text", _MI_File_Export );
			localizer.TryGetString( "AiBEditForm._MI_File_Close.Text", _MI_File_Close );
			localizer.TryGetString( "AiBEditForm._MI_File_Mru.Text", _MI_File_Mru );
			localizer.TryGetString( "AiBEditForm._MI_File_Exit.Text", _MI_File_Exit );

			localizer.TryGetString( "AiBEditForm._MI_Edit.Text", _MI_Edit );
			localizer.TryGetString( "AiBEditForm._MI_Edit_Undo.Text", _MI_Edit_Undo );
			localizer.TryGetString( "AiBEditForm._MI_Edit_Cut.Text", _MI_Edit_Cut );
			localizer.TryGetString( "AiBEditForm._MI_Edit_Copy.Text", _MI_Edit_Copy );
			localizer.TryGetString( "AiBEditForm._MI_Edit_Paste.Text", _MI_Edit_Paste );
			localizer.TryGetString( "AiBEditForm._MI_Edit_Find.Text", _MI_Edit_Find );
			localizer.TryGetString( "AiBEditForm._MI_Edit_FindNext.Text", _MI_Edit_FindNext );
			localizer.TryGetString( "AiBEditForm._MI_Edit_FindPrevious.Text", _MI_Edit_FindPrevious );
			localizer.TryGetString( "AiBEditForm._MI_Edit_SelectAll.Text", _MI_Edit_SelectAll );
			localizer.TryGetString( "AiBEditForm._MI_Edit_JumpToLine.Text", _MI_Edit_JumpToLine );
			localizer.TryGetString( "AiBEditForm._MI_Edit_MatchedBracket.Text", _MI_Edit_MatchedBracket );
			
			localizer.TryGetString( "AiBEditForm._MI_Speak.Text", _MI_Speak );
			localizer.TryGetString( "AiBEditForm._MI_Speak_CaretPos.Text", _MI_Speak_CaretPos );
			localizer.TryGetString( "AiBEditForm._MI_Speak_Selection.Text", _MI_Speak_Selection );
			localizer.TryGetString( "AiBEditForm._MI_Speak_Line.Text", _MI_Speak_Line );
			
			localizer.TryGetString( "AiBEditForm._MI_Tool.Text", _MI_Tool );
			localizer.TryGetString( "AiBEditForm._MI_Tool_Mode.Text", _MI_Tool_Mode );
			localizer.TryGetString( "AiBEditForm._MI_Tool_Outline.Text", _MI_Tool_Outline );
			localizer.TryGetString( "AiBEditForm._MI_Tool_Compile.Text", _MI_Tool_Compile );
			localizer.TryGetString( "AiBEditForm._MI_Tool_ErrorList.Text", _MI_Tool_ErrorList );
			localizer.TryGetString( "AiBEditForm._MI_Tool_AiBTerminal.Text", _MI_Tool_AiBTerminal );
			localizer.TryGetString( "AiBEditForm._MI_Tool_Option.Text", _MI_Tool_Option );
			
			localizer.TryGetString( "AiBEditForm._MI_Window.Text", _MI_Window );
			localizer.TryGetString( "AiBEditForm._MI_Window_Next.Text", _MI_Window_Next );
			localizer.TryGetString( "AiBEditForm._MI_Window_Previous.Text", _MI_Window_Previous );
			localizer.TryGetString( "AiBEditForm._MI_Window_List.Text", _MI_Window_List );
			
			localizer.TryGetString( "AiBEditForm._MI_Braille.Text", _MI_Braille );
			localizer.TryGetString( "AiBEditForm._MI_Braille_Use.Text", _MI_Braille_Use );
			localizer.TryGetString( "AiBEditForm._MI_Braille_BrailleConfig.Text", _MI_Braille_BrailleConfig );
			localizer.TryGetString( "AiBEditForm._MI_Braille_DeviceConfig.Text", _MI_Braille_DeviceConfig );

			localizer.TryGetString( "AiBEditForm._MI_Help.Text", _MI_Help );
			localizer.TryGetString( "AiBEditForm._MI_Help_Manual.Text", _MI_Help_Manual );
			localizer.TryGetString( "AiBEditForm._MI_Help_VersionInfo.Text", _MI_Help_VersionInfo );
#if ACCEDIT_IDE
			localizer.TryGetString( "AiBEditForm._ErrorListView.Columns[0].Text", _ErrorListView.Columns[0] );
			localizer.TryGetString( "AiBEditForm._ErrorListView.Columns[1].Text", _ErrorListView.Columns[1] );
			localizer.TryGetString( "AiBEditForm._ErrorListView.Columns[2].Text", _ErrorListView.Columns[2] );
			localizer.TryGetString( "AiBEditForm._DummyListViewItem.SubItems[0]", _DummyListViewItem.SubItems[0] );
#endif
		}

		/// <summary>
		/// UI i܂B
		/// </summary>
		/// <remarks>
		/// Visual Studio ̃rWAGfB^Ƃ͌݊̂ŒӁB
		/// </remarks>
		void InitializeComponents()
		{
			SuspendLayout();

			// 
			// _MainMenu
			// 
			_MainMenu.MenuItems.AddRange(
					new MenuItem[] {_MI_File, _MI_Edit, _MI_Speak, _MI_Tool,
									_MI_Window, _MI_Braille, _MI_Help}
				);
			// 
			// _MI_File
			// 
			_MI_File.MenuItems.AddRange(
					new MenuItem[] {_MI_File_New, _MI_File_Open, _MI_File_Save, _MI_File_SaveAs, _MI_File_Separator,
						_MI_File_Reload, _MI_File_Export, _MI_File_Separator2,
						_MI_File_Mru, _MI_File_Separator3,
						_MI_File_Close, _MI_File_Exit}
				);
			// 
			// _MI_File_New
			// 
			_MI_File_New.Shortcut = Shortcut.CtrlN;
			_MI_File_New.ShowShortcut = true;
			_MI_File_New.Click += _MI_File_New_Click;
			// 
			// _MI_File_Open
			// 
			_MI_File_Open.Shortcut = Shortcut.CtrlO;
			_MI_File_Open.ShowShortcut = true;
			_MI_File_Open.Click += _MI_File_Open_Click;
			// 
			// _MI_File_Save
			// 
			_MI_File_Save.Shortcut = Shortcut.CtrlS;
			_MI_File_Save.ShowShortcut = true;
			_MI_File_Save.Click += _MI_File_Save_Click;
			// 
			// _MI_File_SaveAs
			// 
			_MI_File_SaveAs.Shortcut = Shortcut.CtrlShiftS;
			_MI_File_SaveAs.ShowShortcut = true;
			_MI_File_SaveAs.Click += _MI_File_SaveAs_Click;
			//
			// _MI_File_Reload
			//
			_MI_File_Reload.MenuItems.AddRange(
					new MenuItem[] {
						_MI_File_Reload_AnalyzeAgain,
						_MI_File_Reload_Separator,
						_MI_File_Reload_Sjis,
						_MI_File_Reload_Jis,
						_MI_File_Reload_Euc,
						_MI_File_Reload_Utf8,
					}
				);
			//
			// _MI_File_Export
			//
			_MI_File_Export.Click += _MI_File_Export_Click;
			//
			// _MI_File_Mru
			//
			_MI_File_Mru.Enabled = false;
			// 
			// _MI_File_Close
			// 
			_MI_File_Close.Shortcut = Shortcut.CtrlW;
			_MI_File_Close.ShowShortcut = true;
			_MI_File_Close.Click += _MI_File_Close_Click;
			// 
			// _MI_File_Exit
			// 
			_MI_File_Exit.Shortcut = Shortcut.CtrlQ;
			_MI_File_Exit.ShowShortcut = true;
			_MI_File_Exit.Click += _MI_File_Exit_Click;
			// 
			// _MI_Edit
			// 
			_MI_Edit.MenuItems.AddRange(
					new MenuItem[] {
						_MI_Edit_Undo,
						_MI_Edit_Separator1,
						_MI_Edit_Cut, _MI_Edit_Copy, _MI_Edit_Paste,
						_MI_Edit_Separator2,
						_MI_Edit_Find, _MI_Edit_FindNext, _MI_Edit_FindPrevious,
						_MI_Edit_Separator3,
						_MI_Edit_SelectAll, _MI_Edit_JumpToLine, _MI_Edit_MatchedBracket
					}
				);
			// 
			// _MI_Edit_Undo
			// 
			_MI_Edit_Undo.Shortcut = Shortcut.CtrlZ;
			_MI_Edit_Undo.ShowShortcut = true;
			_MI_Edit_Undo.Click += _MI_Edit_Undo_Click;
			// 
			// _MI_Edit_Cut
			// 
			_MI_Edit_Cut.Shortcut = Shortcut.CtrlX;
			_MI_Edit_Cut.ShowShortcut = true;
			_MI_Edit_Cut.Click += _MI_Edit_Cut_Click;
			// 
			// _MI_Edit_Copy
			// 
			_MI_Edit_Copy.Shortcut = Shortcut.CtrlC;
			_MI_Edit_Copy.ShowShortcut = true;
			_MI_Edit_Copy.Click += _MI_Edit_Copy_Click;
			// 
			// _MI_Edit_Paste
			// 
			_MI_Edit_Paste.Shortcut = Shortcut.CtrlV;
			_MI_Edit_Paste.ShowShortcut = true;
			_MI_Edit_Paste.Click += _MI_Edit_Paste_Click;
			// 
			// _MI_Edit_Find
			// 
			_MI_Edit_Find.Shortcut = Shortcut.CtrlF;
			_MI_Edit_Find.ShowShortcut = true;
			_MI_Edit_Find.Click += _MI_Edit_Find_Click;
			// 
			// _MI_Edit_FindNext
			// 
			_MI_Edit_FindNext.Shortcut = Shortcut.CtrlG;
			_MI_Edit_FindNext.ShowShortcut = true;
			_MI_Edit_FindNext.Click += _MI_Edit_FindNext_Click;
			// 
			// _MI_Edit_FindPrevious
			// 
			_MI_Edit_FindPrevious.Shortcut = Shortcut.CtrlShiftG;
			_MI_Edit_FindPrevious.ShowShortcut = true;
			_MI_Edit_FindPrevious.Click += _MI_Edit_FindPrevious_Click;
			// 
			// _MI_Edit_SelectAll
			// 
			_MI_Edit_SelectAll.Shortcut = Shortcut.CtrlA;
			_MI_Edit_SelectAll.ShowShortcut = true;
			_MI_Edit_SelectAll.Click += _MI_Edit_SelectAll_Click;
			// 
			// _MI_Edit_JumpToLine
			// 
			_MI_Edit_JumpToLine.Shortcut = Shortcut.CtrlL;
			_MI_Edit_JumpToLine.ShowShortcut = true;
			_MI_Edit_JumpToLine.Click += _MI_Edit_GoToLine_Click;
			//
			// _MI_Edit_MatchedBracket
			//
			_MI_Edit_MatchedBracket.ShortcutKeyDisplayString = "Ctrl+[ / Ctrl+]";
			_MI_Edit_MatchedBracket.ShowShortcut = true;
			_MI_Edit_MatchedBracket.Click += _MI_Edit_MatchedBracket_Click;
			// 
			// _MI_Speak
			// 
			_MI_Speak.MenuItems.AddRange(
					new MenuItem[] {_MI_Speak_CaretPos, _MI_Speak_Selection, _MI_Speak_Line}
				);
			// 
			// _MI_Speak_CaretPos
			// 
			_MI_Speak_CaretPos.ShortcutKeyDisplayString = "Ctrl+L";
			_MI_Speak_CaretPos.ShowShortcut = true;
			_MI_Speak_CaretPos.Click += _MI_Speak_CaretPos_Click;
			//
			// _MI_Speak_Selection
			//
			_MI_Speak_Selection.Click += _MI_Speak_Selection_Click;
			//
			// _MI_Speak_Line
			//
			_MI_Speak_Line.Click += _MI_Speak_Line_Click;
			// 
			// _MI_Tool
			// 
#			if ACCEDIT_IDE
			_MI_Tool.MenuItems.AddRange(
					new MenuItem[] {_MI_Tool_Mode, _MI_Tool_Separator, _MI_Tool_Outline, _MI_Tool_Compile, _MI_Tool_Build, _MI_Tool_ErrorList}
				);
#			else
			_MI_Tool.MenuItems.AddRange(
					new MenuItem[] {_MI_Tool_Mode, _MI_Tool_Separator, _MI_Tool_Outline, _MI_Tool_AiBTerminal, _MI_Tool_Option}
				);
#			endif
			//
			// _MI_Tool_Outline
			// 
			_MI_Tool_Outline.Shortcut = Shortcut.CtrlT;
			_MI_Tool_Outline.ShowShortcut = true;
			_MI_Tool_Outline.Click += _MI_Tool_Outline_Click;
#			if ACCEDIT_IDE
			// 
			// _MI_Tool_Compile
			// 
			_MI_Tool_Compile.Shortcut = Shortcut.CtrlShiftC;
			_MI_Tool_Compile.ShowShortcut = true;
			_MI_Tool_Compile.Click += _MI_Tool_Compile_Click;
			// 
			// _MI_Tool_Build
			// 
			_MI_Tool_Build.Shortcut = Shortcut.CtrlShiftB;
			_MI_Tool_Build.ShowShortcut = true;
			_MI_Tool_Build.Click += _MI_Tool_Build_Click;
			// 
			// _MI_Tool_ErrorList
			// 
			_MI_Tool_ErrorList.Shortcut = Shortcut.CtrlE;
			_MI_Tool_ErrorList.ShowShortcut = true;
			_MI_Tool_ErrorList.Click += _MI_Tool_ErrorList_Click;
#			endif
			//
			// _MI_Tool_AiBTerminal
			//
			_MI_Tool_AiBTerminal.Click += _MI_Tool_AiBTerminal_Click;
			//
			// _MI_Tool_Option
			//
			_MI_Tool_Option.Click += _MI_Tool_Option_Click;
			//
			// _MI_Window
			//
			_MI_Window.MenuItems.AddRange(
					new MenuItem[]{_MI_Window_Next, _MI_Window_Previous, _MI_Window_List, _MI_Window_Separator}
				);
			//
			// _MI_Window_Next
			//
			_MI_Window_Next.ShortcutKeyDisplayString = "Ctrl+Tab / Ctrl+F6";
			_MI_Window_Next.Shortcut = Shortcut.CtrlF6;
			_MI_Window_Next.ShowShortcut = false;
			_MI_Window_Next.Click += _MI_Window_Next_Click;
			//
			// _MI_Window_Previous
			//
			_MI_Window_Previous.ShortcutKeyDisplayString = "Ctrl+Shift+Tab / Ctrl+Shift+F6";
			_MI_Window_Previous.Shortcut = Shortcut.CtrlShiftF6;
			_MI_Window_Previous.ShowShortcut = false;
			_MI_Window_Previous.Click += _MI_Window_Previous_Click;
			//
			// _MI_Window_List
			//
			_MI_Window_List.Shortcut = Shortcut.CtrlD;
			_MI_Window_List.ShowShortcut = true;
			_MI_Window_List.Click += _MI_Window_List_Click;
			// 
			// _MI_Braille
			// 
			_MI_Braille.MenuItems.AddRange(
					new MenuItem[] {_MI_Braille_Use, _MI_Braille_BrailleConfig, _MI_Braille_DeviceConfig}
				);
			// 
			// _MI_Braille_Use
			// 
			_MI_Braille_Use.Click += _MI_Braille_Use_Click;
			// 
			// _MI_Braille_BrailleConfig
			// 
			_MI_Braille_BrailleConfig.Shortcut = Shortcut.CtrlB;
			_MI_Braille_BrailleConfig.ShowShortcut = true;
			_MI_Braille_BrailleConfig.Click += _MI_Braille_BrailleConfig_Click;
			// 
			// _MI_Braille_DeviceConfig
			// 
			_MI_Braille_DeviceConfig.Click += _MI_Braille_DeviceConfig_Click;
			// 
			// _MI_Help
			// 
			_MI_Help.MenuItems.AddRange( new MenuItem[]{
					_MI_Help_Manual, _MI_Help_VersionInfo}
				);
			// 
			// _MI_Help_Manual
			// 
			_MI_Help_Manual.Click += _MI_Help_Manual_Click;
			// 
			// _MI_Help_VersionInfo
			// 
			_MI_Help_VersionInfo.Click += _MI_Help_VersionInfo_Click;
#if ACCEDIT_IDE
			//
			// _ErrorListPanel
			//
			_ErrorListPanel.Dock = DockStyle.Bottom;
			_ErrorListPanel.Controls.Add( _ErrorListLabel );
			_ErrorListPanel.Controls.Add( _ErrorListView );
			_ErrorListPanel.Height = 121;
			//
			// _ErrorListLabel
			//
			_ErrorListLabel.Text = "Error List";
			_ErrorListLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			_ErrorListLabel.Anchor = AnchorStyles.Left | AnchorStyles.Top | AnchorStyles.Right;
			_ErrorListLabel.TabIndex = 0;
			_ErrorListLabel.Width = this.Width;
			_ErrorListLabel.Height = 21;
			//
			// _ErrorListView
			//
			ColumnHeader ch_message = new ColumnHeader();
			ch_message.Text = "Message";
			ch_message.Width = 480;
			ColumnHeader ch_file = new ColumnHeader();
			ch_file.Text = "File";
			ch_file.Width = 80;
			ColumnHeader ch_line = new ColumnHeader();
			ch_line.Text = "LineNumber";
			ch_line.Width = 40;
			_ErrorListView.Anchor = AnchorStyles.Left | AnchorStyles.Bottom | AnchorStyles.Right;
			_ErrorListView.Width = this.Width;
			_ErrorListView.Height = 100;
			_ErrorListView.Top = 21;
			_ErrorListView.TabStop = false;
			_ErrorListView.TabIndex = 1;
			_ErrorListView.View = View.Details;
			_ErrorListView.GridLines = true;
			_ErrorListView.FullRowSelect = true;
			_ErrorListView.MultiSelect = false;
			_ErrorListView.Items.Add( _DummyListViewItem );
			_ErrorListView.Columns.AddRange(
					new ColumnHeader[]{ ch_message, ch_file, ch_line }
				);
			_ErrorListView.KeyDown += _ErrorListView_KeyDown;
			_ErrorListView.ItemActivate += _ErrorListView_ItemActivate;
#endif
			//
			// _TabControl
			//
			_TabControl.Dock = DockStyle.Top;
			_TabControl.Height = 20;
			//
			// _TextBoxPanel
			//
			_TextBoxPanel.Dock = DockStyle.Fill;
			//
			// AiBEditForm
			//
			Controls.Add( _TextBoxPanel );
			Controls.Add( _TabControl );
#if ACCEDIT_IDE
			Controls.Add( _ErrorListPanel );
#endif
			Menu = _MainMenu;
			AllowDrop = true;
			Name = "AiBEditForm";
			Text = "AiB Edit";
			StartPosition = FormStartPosition.Manual;
			DragDrop += Form_DragDrop;
			DragEnter += Form_DragEnter;
			ResumeLayout();
		}

		void SetupMenuItems()
		{
			_MI_File_Reload_AnalyzeAgain.Click += delegate {
				_AppLogic.ReloadDocument( _AppLogic.ActiveDocument );
			};

			_MI_File_Reload_Sjis.Click += delegate {
				_AppLogic.ReloadDocument( _AppLogic.ActiveDocument, Encoding.GetEncoding("Shift_JIS"), false );
			};

			_MI_File_Reload_Jis.Click += delegate {
				_AppLogic.ReloadDocument( _AppLogic.ActiveDocument, Encoding.GetEncoding("iso-2022-jp"), false  );
			};

			_MI_File_Reload_Euc.Click += delegate {
				_AppLogic.ReloadDocument( _AppLogic.ActiveDocument, Encoding.GetEncoding("EUC-JP"), false  );
			};

			_MI_File_Reload_Utf8.Click += delegate {
				_AppLogic.ReloadDocument( _AppLogic.ActiveDocument, Encoding.UTF8, false );
			};
		}
		#endregion

		#region UI components
		MainMenu	_MainMenu	= new MainMenu();
		MyMenuItem	_MI_File			= new MyMenuItem( "&File" );
		MyMenuItem	_MI_File_New		= new MyMenuItem( "&New..." );
		MyMenuItem	_MI_File_Open		= new MyMenuItem( "&Open..." );
		MyMenuItem	_MI_File_Save		= new MyMenuItem( "&Save" );
		MyMenuItem	_MI_File_SaveAs		= new MyMenuItem( "Save &as..." );
		MyMenuItem	_MI_File_Separator	= new MyMenuItem( "-" );
		MyMenuItem	_MI_File_Reload					= new MyMenuItem( "&Reload" );
		MyMenuItem	_MI_File_Reload_AnalyzeAgain	= new MyMenuItem( "Analyze encoding a&gain" );
		MyMenuItem	_MI_File_Reload_Separator		= new MyMenuItem( "-" );
		MyMenuItem	_MI_File_Reload_Sjis			= new MyMenuItem( "as &Shift JIS" );
		MyMenuItem	_MI_File_Reload_Jis				= new MyMenuItem( "as &JIS" );
		MyMenuItem	_MI_File_Reload_Euc				= new MyMenuItem( "as &EUC-JP" );
		MyMenuItem	_MI_File_Reload_Utf8			= new MyMenuItem( "as UTF-&8" );
		MyMenuItem	_MI_File_Export		= new MyMenuItem( "&Export..." );
		MyMenuItem	_MI_File_Separator2	= new MyMenuItem( "-" );
		MyMenuItem	_MI_File_Mru		= new MyMenuItem( "Recent &files" );
		MyMenuItem	_MI_File_Separator3	= new MyMenuItem( "-" );
		MyMenuItem	_MI_File_Close		= new MyMenuItem( "&Close" );
		MyMenuItem	_MI_File_Exit		= new MyMenuItem( "E&xit" );
		MyMenuItem	_MI_Edit				= new MyMenuItem( "&Edit" );
		MyMenuItem	_MI_Edit_Undo			= new MyMenuItem( "&Undo" );
		MyMenuItem	_MI_Edit_Separator1		= new MyMenuItem( "-" );
		MyMenuItem	_MI_Edit_Cut			= new MyMenuItem( "Cu&t" );
		MyMenuItem	_MI_Edit_Copy			= new MyMenuItem( "&Copy" );
		MyMenuItem	_MI_Edit_Paste			= new MyMenuItem( "&Paste" );
		MyMenuItem	_MI_Edit_Separator2		= new MyMenuItem( "-" );
		MyMenuItem	_MI_Edit_Find			= new MyMenuItem( "&Find..." );
		MyMenuItem	_MI_Edit_FindNext		= new MyMenuItem( "Find &next" );
		MyMenuItem	_MI_Edit_FindPrevious	= new MyMenuItem( "Find previou&s" );
		MyMenuItem	_MI_Edit_Separator3		= new MyMenuItem( "-" );
		MyMenuItem	_MI_Edit_SelectAll		= new MyMenuItem( "Select &All" );
		MyMenuItem	_MI_Edit_JumpToLine		= new MyMenuItem( "&Go to line..." );
		MyMenuItem	_MI_Edit_MatchedBracket	= new MyMenuItem( "Go to matched &bracket" );
		MyMenuItem	_MI_Speak				= new MyMenuItem( "&Speak" );
		MyMenuItem	_MI_Speak_CaretPos		= new MyMenuItem( "Speak &cursor position" );
		MyMenuItem	_MI_Speak_Selection		= new MyMenuItem( "Speak &selection" );
		MyMenuItem	_MI_Speak_Line			= new MyMenuItem( "Speak &line content" );
		MyMenuItem	_MI_Tool				= new MyMenuItem( "&Tools" );
		MyMenuItem	_MI_Tool_Mode			= new MyMenuItem( "Edit &mode" );
		MyMenuItem	_MI_Tool_Separator		= new MyMenuItem( "-" );
		MyMenuItem	_MI_Tool_Outline		= new MyMenuItem( "Show ou&tline..." );
		MyMenuItem	_MI_Tool_Compile		= new MyMenuItem( "&Compile..." );
		MyMenuItem	_MI_Tool_Build			= new MyMenuItem( "&Build..." );
		MyMenuItem	_MI_Tool_ErrorList		= new MyMenuItem( "Show &error list" );
		MyMenuItem	_MI_Tool_AiBTerminal	= new MyMenuItem( "Launch AiB Te&rminal" );
		MyMenuItem	_MI_Tool_Option			= new MyMenuItem( "&Options..." );
		MyMenuItem	_MI_Window			= new MyMenuItem( "&Window" );
		MyMenuItem	_MI_Window_Next		= new MyMenuItem( "&Next window" );
		MyMenuItem	_MI_Window_Previous	= new MyMenuItem( "&Previous window" );
		MyMenuItem	_MI_Window_List		= new MyMenuItem( "List up &windows..." );
		MyMenuItem	_MI_Window_Separator= new MyMenuItem( "-" );
		MyMenuItem	_MI_Braille					= new MyMenuItem( "&Braille display" );
		MyMenuItem	_MI_Braille_Use				= new MyMenuItem( "&Use braille display" );
		MyMenuItem	_MI_Braille_DeviceConfig	= new MyMenuItem( "&Device preference..." );
		MyMenuItem	_MI_Braille_BrailleConfig	= new MyMenuItem( "&Braille preference..." );
		MyMenuItem	_MI_Help				= new MyMenuItem( "&Help" );
		MyMenuItem	_MI_Help_Manual			= new MyMenuItem( "Open &Manual..." );
		MyMenuItem	_MI_Help_VersionInfo	= new MyMenuItem( "Version inform&ation..." );
		AiBTabControl<Document>	_TabControl	= new AiBTabControl<Document>();
		Panel		_TextBoxPanel	= new Panel();
		Panel		_ErrorListPanel	= new Panel();
		Label		_ErrorListLabel = new Label();
		ListView	_ErrorListView	= new ListView();
		ListViewItem	_DummyListViewItem = new ListViewItem(
				new String[]{"(no error)", "", "", ""}
			);
		ContextMenu	_SpeakMenu = null;
		#endregion // UI components

		#region Utility
		class Utl
		{
			/// <summary>
			/// w肵pPʂ̌ʒuA
			/// w蕶̉ڂɑΉ̂vZB
			/// </summary>
			/// <param name="str">w蕶</param>
			/// <param name="halfWidthIndex">pPʂ̌ʒuCfbNX</param>
			/// <param name="tabWidth">^u</param>
			/// <returns>Ή镶CfbNX</returns>
			/// <remarks>
			/// w肵ʒu񔼊p̒Ȃ΁Ã̕CfbNXԂB
			/// </remarks>
			public static int
			CalcCharIndexFromHalfWidthIndex( string str, int halfWidthIndex, int tabWidth )
			{
				int charPos;
				int	hwPos			= 0;
				int offsetToNext	= 0;
				
				// 擪ꕶĂApPʂł̕ώZĂ
				charPos = 0;
				while( charPos < str.Length )
				{
					char ch = str[charPos];
					
					// ^uH
					if( '\t' == ch )
					{
						offsetToNext = tabWidth - (hwPos % tabWidth);
					}
					// pH
					else if( IsHalfWidthChar(ch) )
					{
						offsetToNext = 1;
					}
					// SpH
					else
					{
						offsetToNext = 2;
					}

					// ̕
					hwPos += offsetToNext;
					charPos++;
					
					// w肳ꂽ𒴂ȂA钼O̕JEgԂ
					if( halfWidthIndex < hwPos )
					{
						return charPos - 1;
					}
				}

				// SÎɁA܂w肳ꂽɒBȂB
				// ܂w肳ꂽ傫ƂȂ̂ŁAsƂ
				return str.Length;
			}
			
			/// <summary>
			/// w蕶pǂ
			/// </summary>
			/// <param name="ch">ffΏە</param>
			/// <returns>p true</returns>
			static bool IsHalfWidthChar( char ch )
			{
				// is in "Basic-Latin"?
				if( 0x20 <= ch && ch < 0x7F )
				{
					return true;
				}
				// is in "Half-width CJK punctuation"?
				if( 0xFF61 < ch && ch < 0xFF64 )
				{
					return true;
				}
				// is in "Half-width Katakana variants"?
				if( 0xFF65 < ch && ch < 0xFF9F )
				{
					return true;
				}
				// is in "Half-width Hangle variants"?
				if( 0xFFA0 < ch && ch < 0xFFBD )
				{
					return true;
				}
				// is in "Half-width Symbol variants"?
				if( 0xFFE8 < ch && ch < 0xFFEE )
				{
					return true;
				}

				return false;
			}
		}
		#endregion
	}
}
