// file: Actions.cs
// brief: actions
// update: 2008-11-22
//=========================================================
using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
using Win32Exception = System.ComponentModel.Win32Exception;
using Debug = System.Diagnostics.Debug;

namespace Sgry.AiBTools.AiBEdit
{
	using AT;
	using Gui;

	internal delegate void AiBEditAction( AppLogic app );

	static class Actions
	{
		#region Lbg̈ړ
		/// <summary>
		/// _CAO\ă[Uw肵sɃLbgړ܂B
		/// </summary>
		public readonly static AiBEditAction GoToLine
			= delegate( AppLogic appLogic )
		{
			DialogResult result;
			int line, col;
			Document doc = appLogic.ActiveDocument;

			if( doc == null )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// get current caret position
			doc.Editor.GetCaretIndex( out line, out col );
			
			// show dialog to ask user where the caret should be moved to
			using( GotoLineDialog dialog = new GotoLineDialog() )
			{
				dialog.StartPosition = FormStartPosition.CenterParent;
				dialog.LineNumber = line + 1;

				// show dialog
				result = dialog.ShowDialog( appLogic.MainForm );
				if( result != DialogResult.OK )
				{
					return;
				}

				// move there
				doc.Editor.SetCaretIndex( dialog.LineNumber - 1, 0 );
				doc.Editor.ScrollToCaret();
			}
		};

		/// <summary>
		/// LbgʒuɂJbRɑΉJbR̈ʒuɃLbgړ܂B
		/// </summary>
		public readonly static AiBEditAction GoToMatchedBracket
			= delegate( AppLogic appLogic )
		{
			Document doc = appLogic.ActiveDocument;
			ITextEditor editor = doc.Editor;
			int line, col;
			string message;
			string format;
			int caretIndex;
			int pairIndex;

			if( doc == null )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// find pair and go there
			caretIndex = editor.GetCaretIndex();
			pairIndex = FindLogic.FindMatchedBracket( editor.Text, caretIndex );
			if( pairIndex == -1 )
			{
				Win32.MessageBeep_Notify();
				return;
			}
			editor.SetSelection( pairIndex, pairIndex );
			editor.ScrollToCaret();

			// make message
			editor.GetCaretIndex( out line, out col );
			format = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_SayCurrentLine", "line {0} column {1}" );
			message = String.Format( format, line+1, col+1 );

			// say message
			AutoSpeaker.Instance.Speak( message );
		};
		#endregion

		#region Speak
		/// <summary>
		/// Lbg̈ʒuǂݏグ
		/// </summary>
		public readonly static AiBEditAction SpeakCaretPos
			= delegate( AppLogic appLogic )
		{
			Document doc = appLogic.ActiveDocument;
			int		line, col;
			string	message;
			string	format;

			if( doc == null )
				return;

			// make message
			doc.Editor.GetCaretIndex( out line, out col );
			format = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_SayCurrentLine", "line {0}  column {1}" );
			message = String.Format( format, line+1, col+1 );

			// say message
			if( AutoSpeaker.IsAlive() )
			{
				AutoSpeaker.Instance.Speak( message );
			}
			else
			{
				NbsMessageBox.Show( appLogic.MainForm, message );
			}
		};

		/// <summary>
		/// I𒆃eLXgǂݏグ
		/// </summary>
		public readonly static AiBEditAction SpeakSelection
			= delegate( AppLogic appLogic )
		{
			Document doc = appLogic.ActiveDocument;
			if( doc == null )
				return;

			AutoSpeaker.Instance.Speak( doc.Editor.SelectedText );
		};

		/// <summary>
		/// Lbĝsǂݏグ
		/// </summary>
		public readonly static AiBEditAction SpeakLine
			= delegate( AppLogic appLogic )
		{
			Document doc = appLogic.ActiveDocument;
			int caretIndex;
			int caretLineIndex;
			string line;

			if( doc == null )
				return;

			caretIndex = doc.Editor.GetCaretIndex();
			caretLineIndex = doc.Editor.GetLineIndexFromCharIndex( caretIndex );
			line = doc.Editor.GetLineContent( caretLineIndex );

			AutoSpeaker.Instance.Stop();
			AutoSpeaker.Instance.Speak( line );
		};
		#endregion

		#region Find
		/// <summary>
		/// _CAOJĕ񌟍s
		/// </summary>
		public readonly static AiBEditAction Find
			= delegate( AppLogic appLogic )
		{
			Debug.Assert( appLogic != null );
			Debug.Assert( appLogic.ActiveDocument != null );
			Debug.Assert( appLogic.ActiveDocument.Editor != null );

			ITextEditor		editor = appLogic.ActiveDocument.Editor;
			DialogResult	result;
			FindDialog		findForm;
			FindCondition	condition = new FindCondition( AppConfig.FindCondition );

			// if nothing selected, use word at caret as initial seach pattern.
			// or something selected, use selected text instead.
			if( editor.SelectedText.Length == 0 )
			{
				condition.Pattern = editor.GetWordAt( editor.GetCaretIndex() );
				if( condition.Pattern == null )
				{
					condition.Pattern = "";
				}
			}
			else
			{
				condition.Pattern = editor.SelectedText;
			}

			using( findForm = new FindDialog(ref condition) )
			{
				// ask find condition
				result = findForm.ShowDialog( appLogic.MainForm );
				if( result == DialogResult.Cancel )
				{
					return;
				}
				AppConfig.FindCondition = condition;

				// start search
				if( findForm.FindBackward )
				{
					FindPrevious( appLogic );
				}
				else
				{
					FindNext( appLogic );
				}
			}
		};

		/// <summary>
		/// ǑŌs܂B
		/// </summary>
		public readonly static AiBEditAction FindNext
			= delegate( AppLogic appLogic )
		{
			Debug.Assert( appLogic != null );
			Debug.Assert( appLogic.ActiveDocument != null );
			Debug.Assert( appLogic.ActiveDocument.Editor != null );

			ITextEditor editor = appLogic.ActiveDocument.Editor;
			int matchIndex;
			int	matchLength;
			bool found;

			if( AppConfig.FindCondition.Pattern == String.Empty )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// find the pattern
			found = FindLogic.FindNext( editor, AppConfig.FindCondition, out matchIndex, out matchLength );
			if( found != true )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// select the pattern
			editor.SetSelection( matchIndex, matchIndex+matchLength );
			editor.ScrollToCaret();
		};

		/// <summary>
		/// ǑőOs܂B
		/// </summary>
		public readonly static AiBEditAction FindPrevious
			= delegate( AppLogic appLogic )
		{
			Debug.Assert( appLogic != null );
			Debug.Assert( appLogic.ActiveDocument != null );
			Debug.Assert( appLogic.ActiveDocument.Editor != null );

			ITextEditor editor = appLogic.ActiveDocument.Editor;
			int matchIndex;
			int	matchLength;
			bool found;

			if( AppConfig.FindCondition.Pattern == String.Empty )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// find the pattern
			found = FindLogic.FindPrevious( editor, AppConfig.FindCondition, out matchIndex, out matchLength );
			if( found != true )
			{
				Win32.MessageBeep_Notify();
				return;
			}
			
			// select the pattern
			editor.SetSelection( matchIndex, matchIndex+matchLength );
			editor.ScrollToCaret();
		};
		#endregion

		#region UI
		/// <summary>
		/// ނ̈ꗗ\
		/// </summary>
		public readonly static AiBEditAction ShowDocumentList
			= delegate( AppLogic app )
		{
			DialogResult result;

			if( app.Documents.Count == 0 )
			{
				Win32.MessageBeep_Notify();
				return;
			}

			// show dialog
			using( DocumentListDialog dialog = new DocumentListDialog(app.Documents, app.ActiveDocument) )
			{
				result = dialog.ShowDialog( app.MainForm );
				if( result != DialogResult.OK )
				{
					TextEditorBrailler.Inst.UpdateDisplay();
					return;
				}
				app.DocViewMan_Activate( dialog.SelectedDocument );
			}
		};

		/// <summary>
		/// AEgC_CAO\܂B
		/// </summary>
		public readonly static AiBEditAction ShowOutlineDialog
			= delegate( AppLogic app )
		{
			Document doc = app.ActiveDocument;
			ITextEditor editor;
			int newPos;

			if( doc == null )
				return;

			editor = doc.Editor;

			// show dialog
			newPos = doc.FileType.ShowOutline( app.MainForm, editor.Text, editor.GetCaretIndex() );
			if( 0 < newPos )
			{
				// IꂽV{̈ʒuֈړ
				editor.SetCaretIndex( editor.GetLineIndexFromCharIndex(newPos), 0 );
				editor.ScrollToCaret();
			}
			else
			{
				TextEditorBrailler.Inst.UpdateDisplay();
			}
		};
		#endregion

		/// <summary>
		/// AiB Terminal N܂B
		/// </summary>
		public readonly static AiBEditAction LaunchAiBTerminal
			= delegate( AppLogic app )
		{
			Process p = new Process();
			string appDir, docDir, workDir;

			appDir = Path.GetDirectoryName( Application.ExecutablePath );

			// NvZX̃JgfBNg
			workDir = appDir;
			if( app.ActiveDocument != null )
			{
				docDir = Path.GetDirectoryName( app.ActiveDocument.Path );
				if( Directory.Exists(docDir) )
				{
					workDir = docDir;
				}
			}

			// AiB Terminal N
			try
			{
				p.StartInfo.FileName = Path.Combine( appDir, "AiBTerminal.exe" );
				p.StartInfo.WorkingDirectory = workDir;
				p.StartInfo.ErrorDialog = false;
				p.Start();
			}
			catch( Win32Exception )
			{
				string message;
				message = AppLogic.Localizer.TryGetString( "AiBEditForm.Msg_FailedToLaunchAiBTerminal", "Failed to launch AiB Terminal. AiB Tools was not install properly." );
				NbsMessageBox.Show( app.MainForm, message, MessageBoxButtons.OK, MessageBoxIcon.Error );
			}
			finally
			{
				p.Dispose();
			}
		};
	}
}
