@echo off
setlocal

::-------------------------------------
:: check env.

set assembly_name=GetWinArch.exe

:: UPX.EXE exists?
(upx > NUL) 2> NUL
if not ERRORLEVEL == 9009 (
	set upx_exists=1
)

::-------------------------------------
:: set build option and prepare building
::      /O2: optimize size
::      /LD: create DLL
::      /EHsc: enable C++ exception
set options=-O2  -EHsc  -Fe%assembly_name%  -DNDEBUG  -DUNICODE
set sources=..\*.c  ..\*.def
set libraries=user32.lib
if not exist obj (
	mkdir obj
)

::-------------------------------------
:: build
cd obj
cl  -nologo  %options%  %sources%  %libraries%
cd..

::-------------------------------------
:: copy binary to package dir
if not exist package (
	mkdir package
)
move /Y  obj\%assembly_name%  package\  2> NUL

::-------------------------------------
:: compress binary
if _%upx_exists% == _1 (
	upx -q -9 package\%assembly_name%
)

endlocal
