// file : GetWinArch.c
// brief : Distinguish CPU architecture that the running Windows was designed for
// author : SGRY (YAMAMOTO Suguru)
// update : 2007-04-30
// license : MIT License (see END of this file)
//=========================================================
#define _WIN32_WINNT  0x0501 // enable APIs only for Windows XP or later
#include <windows.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

//-------------------------------------
// function : GetWinArch
// brief : Get the CPU architecture that this Windows was designed for
// returns :
//      0:x86, 1:MIPS, 2:Alpha, 3:PPC, 4:SHX, 5:ARM,
//      6:IA64, 7:Alpha64, 8:MSIL, 9:AMD64, 10:IA32 on Win64
//-------------------------------------
int
GetWinArch( void )
{
	SYSTEM_INFO sysInfo;

	// get actual OS information (not emulated one by WOW64)
	GetNativeSystemInfo( &sysInfo );

	// return architecture id
	return sysInfo.wProcessorArchitecture;
}

//-------------------------------------
// function : main
// brief : application entry point
//-------------------------------------
int
main( int argc, char* argv[] )
{
	int arch;
	argc; argv;

	arch = GetWinArch();
	switch( arch )
	{
		case PROCESSOR_ARCHITECTURE_INTEL:
			printf( "This Windows is for x86 CPU." );
			break;

		case PROCESSOR_ARCHITECTURE_IA64:
			printf( "This Windows is for IA64 CPU arch." );
			break;

		case PROCESSOR_ARCHITECTURE_AMD64:
			printf( "This Windows is for x64 CPU arch." );
			break;

		default:
			printf( "This Windows is for unknown CPU arch." );
			break;
	}

	return arch;
}


#ifdef __cplusplus
} // extern "C"
#endif

/**********************************************************
Copyright (c) 2006-2007 YAMAMOTO Suguru

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
copies of the Software, and to permit persons to whom the Software is 
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN 
THE SOFTWARE.
**********************************************************/
