// file: main.cpp
// brief: entry points
// author: SGRY (YAMAMOTO Suguru)
// update: 2007-12-08
// license: zlib License (see END of this file)
//=========================================================
#include <windows.h>
#include <stdio.h>
#include "SgRichEdit.h"

#ifndef UNICODE
#	error this project must be built in Unicode environment
#endif

#ifndef NDEBUG
static HWND CreateTestWindow( HINSTANCE instance );
static void DoMessageLoop();
#endif
static HMODULE gRichEditDll = NULL;

//=========================================================
//  entry point functions
//=========================================================
#ifndef NDEBUG
int
main( int /*argc*/, char* /*argv[]*/ )
{
	DWORD style = WS_VISIBLE | WS_TABSTOP | WS_VSCROLL
		| ES_MULTILINE | ES_NOHIDESEL/* | ES_SUNKEN*/
		| ES_WANTRETURN | ES_AUTOVSCROLL;
	HWND rich = NULL;

	// initialize COM framework
	CoInitialize( 0 );

	// load DLL of RichEdit 2
	gRichEditDll = LoadLibraryA( "riched20.dll" );
	if( gRichEditDll == NULL )
	{
		perror( "Failed to load riched20.dll.\n" );
		return 1;
	}

	// create a window of SgRichEdit
	rich = CreateSgRichEdit( CreateTestWindow(NULL), style );
	if( rich == NULL )
	{
		perror( "Failed to create window of SgRichEdit" );
		return 2;
	}

	SendMessage( rich, SRE_SETAUTOINDENTMODE, SRE_AIM_C, 0 );
	SendMessage( rich, SRE_SETSMARTHOME, 1, 0 );

	// do message loop
	DoMessageLoop();

	// dispose resources
	if( rich != NULL )
	{
		DestroyWindow( rich );
	}
	if( gRichEditDll != NULL )
	{
		FreeLibrary( gRichEditDll );
	}

	return 0;
}
#else // NDEBUG
BOOL APIENTRY
DllMain( HMODULE /*moduleHdl*/, ULONG callReason, void* /*reserved*/ )
{
	if( callReason == DLL_PROCESS_ATTACH )
	{
		// load DLL of RichEdit 2
		gRichEditDll = LoadLibraryA( "riched20.dll" );
		if( gRichEditDll == NULL )
		{
			perror( "[SgRichEdit] Failed to load riched20.dll.\n" );
			return FALSE;
		}
	}
	else if( callReason == DLL_PROCESS_DETACH )
	{
		// dispose resources
		if( gRichEditDll != NULL )
		{
			FreeLibrary( gRichEditDll );
		}
	}

	return TRUE;
}
#endif

#ifndef NDEBUG
static LRESULT CALLBACK
TestWindowProc( HWND window, UINT message, WPARAM wparam, LPARAM lparam )
{
	if( message == WM_NCDESTROY )
	{
		PostQuitMessage( 0 );
		return 0;
	}

	return DefWindowProc( window, message, wparam, lparam );
}
static HWND
CreateTestWindow( HINSTANCE instance )
{
	const TCHAR * className = TEXT("MyTestWindow");
	WNDCLASS	winc;

	winc.style			= CS_HREDRAW | CS_VREDRAW;
	winc.lpfnWndProc	= &TestWindowProc;
	winc.cbClsExtra		= 0;
	winc.cbWndExtra		= 0;
	winc.hInstance		= GetModuleHandle( NULL );
	winc.hIcon			= NULL;
	winc.hCursor		= LoadCursor( NULL, IDC_ARROW );
	winc.hbrBackground	= (HBRUSH)GetStockObject( GRAY_BRUSH );
	winc.lpszMenuName	= NULL;
	winc.lpszClassName	= className;

	if( RegisterClass(&winc) == 0 )
	{
		return NULL;
	}

	return CreateWindow( className, className, WS_CAPTION|WS_VISIBLE|WS_SYSMENU,
						0, 0, 300, 300, NULL, NULL, instance, NULL );
}
static void
DoMessageLoop()
{
	int	rc = 1;
	MSG	msg;

	while( rc != 0 )
	{
		rc = GetMessage( &msg, NULL, 0, 0 );
		if( rc == -1 )
		{
			break;
		}

		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
}
#endif

/**********************************************************
Copyright (C) 2006-2009 YAMAMOTO Suguru

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
**********************************************************/
