@echo off
setlocal

::-------------------------------------
:: check env.

:: is x64 machine?
set is_x64=0
if %is_x64% == 1 (
	set assembly_name=SgRichEdit64.dll
) else (
	set assembly_name=SgRichEdit32.dll
)

:: UPX.EXE exists?
(upx > NUL) 2> NUL
if not ERRORLEVEL == 9009 (
	set upx_exists=1
)

::-------------------------------------
:: set build option and prepare building
::      /O2: optimize size
::      /LD: create DLL
::      /EHsc: enable C++ exception
set options=-O2  -LD  -EHsc  -Fe%assembly_name%  -DNDEBUG  -DDLL  -D_CRT_SECURE_NO_DEPRECATE -DUNICODE
set sources=..\*.cpp  ..\*.def
set libraries=user32.lib  ole32.lib  oleacc.lib  oleaut32.lib
if not exist obj (
	mkdir obj
)

::-------------------------------------
:: build
cd obj
rc ..\SgRichEdit.rc
move ..\SgRichEdit.res .
cl  -nologo  %options%  %sources%  SgRichEdit.res  %libraries%
cd..

::-------------------------------------
:: copy binary to package dir
if not exist package (
	mkdir package
)
move /Y  obj\%assembly_name%  package\  2> NUL

endlocal
