// file: SgRichEdit.h
// brief: a customed RichEdit for source code editing.
// author: SGRY (YAMAMOTO Suguru)
// update: 2009-05-05
// license: zlib License (see END of this file)
//=========================================================
#pragma once
#include <windows.h>

//=========================================================
//
//  types and constants
//
//=========================================================

//-------------------------------------
// function: SRE_WMHOOKPROC
// brief: prototype of window message hook procedure for SgRichEdit.
// param:
//    hWnd       ... window handle
//    msg        ... window message
//    wParam     ... a parameter of window message
//    lParam     ... another parameter of window message
//    out_result ... result code
// returns: TRUE if hook procedure executed custom action, otherwise FALSE
//-------------------------------------
typedef BOOL (CALLBACK* SRE_WMHOOKPROC)( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam, LRESULT* out_result );

//-------------------------------------
// message: SRE_SETAUTOINDENTMODE( indentMode )
// brief: set auto-indent mode of the SgRichEdit.
//-------------------------------------
#define SRE_SETAUTOINDENTMODE	(WM_USER + 1)

//-------------------------------------
// message: SRE_GETAUTOINDENTMODE
// brief: get auto-indent mode of the SgRichEdit.
// returns: 0 ... disabled  /  1 ... enabled
//-------------------------------------
#define SRE_GETAUTOINDENTMODE	(WM_USER + 2)

//-------------------------------------
// message: SRE_SETACCNAME( accessibleName )
// brief: set AccessibleName MSAA property
//-------------------------------------
#define SRE_SETACCNAME	(WM_USER + 3)

//-------------------------------------
// message: SRE_GETACCNAME( out_accessibleName, maxLength )
// brief: get AccessibleName MSAA property
//-------------------------------------
#define SRE_GETACCNAME	(WM_USER + 4)

//-------------------------------------
// message: SRE_SETACCDESCRIPTION( accessibleDescription )
// brief: set AccessibleDescription MSAA property
//-------------------------------------
#define SRE_SETACCDESCRIPTION	(WM_USER + 5)

//-------------------------------------
// message: SRE_GETACCDESCRIPTION( out_accessibleDescription, maxLength )
// brief: get AccessibleDescription MSAA property
//-------------------------------------
#define SRE_GETACCDESCRIPTION	(WM_USER + 6)

//-------------------------------------
// message: SRE_SETENABLEMSAA( enable )
// brief: enable original MSAA feature
//-------------------------------------
#define SRE_SETENABLEMSAA	(WM_USER + 7)

//-------------------------------------
// message: SRE_GETENABLEMSAA()
// brief: distinguish if the original MSAA feature was enabled or not
// returns: 0 ... disabled  /  1 ... enabled
//-------------------------------------
#define SRE_GETENABLEMSAA	(WM_USER + 8)

//-------------------------------------
// message: SRE_SETSMARTHOME( enable )
// brief: enable or disable smart-home feature
//-------------------------------------
#define SRE_SETSMARTHOME	(WM_USER + 9)

//-------------------------------------
// message: SRE_GETSMARTHOME()
// brief: check whether the smart-home feature is enabled or not
// returns: 0 ... disabled  /  1 ... enabled
//-------------------------------------
#define SRE_GETSMARTHOME	(WM_USER + 10)

//-------------------------------------
// message: SRE_SETWMHOOKPROC()
// brief: sets window message hooking procedure
// params: wParam ... pointer to the hook function or NULL.
// returns: 0 ... disabled  /  1 ... enabled
//-------------------------------------
#define SRE_SETWMHOOKPROC	(WM_USER + 11)

//-------------------------------------
// enum: AutoIndentMode
// brief: flags to identify auto indent mode used in SgRichEdit
//-------------------------------------
typedef enum tagAutoIndentMode
{
	SRE_AIM_Dummy = -1,
	SRE_AIM_None = 0,
	SRE_AIM_General = 1,
	SRE_AIM_C = 2,
	SRE_AIM_Ruby = 3
} AutoIndentMode;


//=========================================================
//
//  functions
//
//=========================================================

//-------------------------------------
// function : CreateSgRichEdit
// brief : create a SgRichEdit window
//-------------------------------------
extern "C" HWND WINAPI CreateSgRichEdit( HWND parent, DWORD windowStyle );

/**********************************************************
Copyright (C) 2006-2009 YAMAMOTO Suguru

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
**********************************************************/
