// file: OleWindowAdapter.h
// brief: IOleWindow interface adapter designed for AccObj
// author: SGRY (YAMAMOTO Suguru)
// update: 2007-04-24
// license: zlib License (see END of this file)
//=========================================================
#pragma once
#include "AccObj.h"

/*
Logically, I could implement IOleWindow interface to the accessible object of SgRichEdit.
But when I implemented both IAccessible and IOleWindow,
VC said it can't be possible to dynamic_cast the accessible object to IUnknown.
So I made this class.

The AddRef/Release method of this class are dummies (They do nothing).
So the accessible object must maintenance the life span of the object of this class.
*/

// IOleWindow adapter class for SgRichEdit
class OleWindowAdapter : public IOleWindow
{
	SgRichEdit::AccObj * _owner;
	
	public:
		OleWindowAdapter( SgRichEdit::AccObj * ownerRef );

	// IUnknown
	public:
		virtual HRESULT STDMETHODCALLTYPE
			QueryInterface( const IID & iid, void ** out_objects );

		virtual ULONG STDMETHODCALLTYPE
			AddRef();

		virtual ULONG STDMETHODCALLTYPE
			Release();

	// IOleWindow
	public:
        virtual HRESULT STDMETHODCALLTYPE
			GetWindow( HWND * out_windowHdl );
        
        virtual HRESULT STDMETHODCALLTYPE
			ContextSensitiveHelp( BOOL enterMode );
};

/**********************************************************
Copyright (C) 2006-2009 YAMAMOTO Suguru

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
**********************************************************/
