// file: OleWindowAdapter.cpp
// brief: IOleWindow interface adapter designed for AccObj
// author: SGRY (YAMAMOTO Suguru)
// update: 2007-04-24
// license: zlib License (see END of this file)
//=========================================================
#include "OleWindowAdapter.h"

using SgRichEdit::AccObj;

//=========================================================
//  Init / Dispose
//=========================================================

//-------------------------------------
// function : OleWindowAdapter::ctor
//-------------------------------------
OleWindowAdapter::OleWindowAdapter( AccObj * ownerRef )
{
	_owner = ownerRef;
}


//=========================================================
//  IUnknown
//=========================================================

//-------------------------------------
// function : OleWindowAdapter::AddRef
//-------------------------------------
ULONG STDMETHODCALLTYPE
OleWindowAdapter::AddRef()
{
	return 1;
}

//-------------------------------------
// function : OleWindowAdapter::Release
//-------------------------------------
ULONG STDMETHODCALLTYPE
OleWindowAdapter::Release()
{
	return 1;
}

//-------------------------------------
// function : OleWindowAdapter::QueryInterface
//-------------------------------------
HRESULT STDMETHODCALLTYPE
OleWindowAdapter::QueryInterface( const IID & iid, void ** out_objects )
{
	//MY_LOG("OleWindowAdapter::QueryInterface (%s)", Sgry::Com::GetInterfaceName(iid).c_str());
	return _owner->QueryInterface( iid, out_objects );
}


//=========================================================
//  IOleWindow
//=========================================================

//-------------------------------------
// function : OleWindowAdapter::GetWindow
//-------------------------------------
HRESULT STDMETHODCALLTYPE
OleWindowAdapter::GetWindow( HWND * out_windowHdl )
{
	MY_LOG("OleWindowAdapter::GetWindow");
	*out_windowHdl = _owner->GetWindow();
	return S_OK;
}

//-------------------------------------
// function : OleWindowAdapter::ContextSensitiveHelp
//-------------------------------------
HRESULT STDMETHODCALLTYPE
OleWindowAdapter::ContextSensitiveHelp( BOOL /*enterMode*/ )
{
	MY_LOG("OleWindowAdapter::ContextSensitiveHelp");
	return S_OK;
}

/**********************************************************
Copyright (C) 2006-2009 YAMAMOTO Suguru

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
**********************************************************/
