// file: DispatchAdapter.h
// brief: IDispatch interface adapter for AccObj
// author: SGRY (YAMAMOTO Suguru)
// update: 2007-04-24
// license: zlib License (see END of this file)
//=========================================================
#pragma once
#include "AccObj.h"

// IDispatch adapter class for SgRichEdit
class DispatchAdapter : IDispatch
{
	SgRichEdit::AccObj * _owner;
	
	public:
		DispatchAdapter( SgRichEdit::AccObj * ownerRef );

	// IUnknown
	public:
		virtual HRESULT STDMETHODCALLTYPE
			QueryInterface( const IID & iid, void ** out_objects );

		virtual ULONG STDMETHODCALLTYPE
			AddRef();

		virtual ULONG STDMETHODCALLTYPE
			Release();
	
	// IDispatch
	public:
        virtual HRESULT STDMETHODCALLTYPE
			GetTypeInfoCount( UINT * out_typeInfoCount );
        
        virtual HRESULT STDMETHODCALLTYPE
			GetTypeInfo( UINT typeInfoIndex, LCID lcid, ITypeInfo ** out_typeInfo );
        
        virtual HRESULT STDMETHODCALLTYPE
			GetIDsOfNames( const IID & iid, OLECHAR ** names, UINT nameCount, LCID lcid, DISPID * out_dispId );
        
        virtual HRESULT STDMETHODCALLTYPE
			Invoke( DISPID dispIdMember, const IID & iid, LCID lcid, WORD flags,
					DISPPARAMS * io_dispParams, VARIANT * out_result,
					EXCEPINFO * out_excepInfo, UINT * out_argErr
				);
};

/**********************************************************
Copyright (C) 2006-2009 YAMAMOTO Suguru

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
**********************************************************/
