// file: DispatchAdapter.cpp
// brief: IDispatch interface adapter designed for AccObj
// author: SGRY (YAMAMOTO Suguru)
// update: 2007-04-24
// license: zlib License (see END of this file)
//=========================================================
#include "DispatchAdapter.h"

using SgRichEdit::AccObj;

//=========================================================
//  Init / Dispose
//=========================================================

//-------------------------------------
// function : DispatchAdapter::ctor
//-------------------------------------
DispatchAdapter::DispatchAdapter( AccObj * ownerRef )
{
	_owner = ownerRef;
}


//=========================================================
//  IUnknown
//=========================================================

//-------------------------------------
// function : DispatchAdapter::AddRef
//-------------------------------------
ULONG STDMETHODCALLTYPE
DispatchAdapter::AddRef()
{
	return 1;
}

//-------------------------------------
// function : DispatchAdapter::Release
//-------------------------------------
ULONG STDMETHODCALLTYPE
DispatchAdapter::Release()
{
	return 1;
}

//-------------------------------------
// function : DispatchAdapter::QueryInterface
//-------------------------------------
HRESULT STDMETHODCALLTYPE
DispatchAdapter::QueryInterface( const IID & iid, void ** out_objects )
{
	return _owner->QueryInterface( iid, out_objects );
}


//=========================================================
//  IDispatch
//=========================================================

//-------------------------------------
// function : DispatchAdapter::GetTypeInfoCount
// brief : get the number of type information that this COM-object provides
//-------------------------------------
HRESULT STDMETHODCALLTYPE
DispatchAdapter::GetTypeInfoCount( UINT * out_typeInfoCount )
{
	MY_LOG("DispatchAdapter::GetTypeInfoCount");
	*out_typeInfoCount = 0;
	return E_NOTIMPL;
}

//-------------------------------------
// function : DispatchAdapter::GetTypeInfo
// brief : get type information of this COM-object
//-------------------------------------
HRESULT STDMETHODCALLTYPE
DispatchAdapter::GetTypeInfo( UINT /*typeInfoIndex*/, LCID /*lcid*/, ITypeInfo ** out_typeInfo )
{
	MY_LOG("DispatchAdapter::GetTypeInfo");
	*out_typeInfo = 0;
	return E_NOTIMPL;
}

//-------------------------------------
// function : DispatchAdapter::GetIDsOfNames
// brief : get the COM-object's member IDs by member names
//-------------------------------------
HRESULT STDMETHODCALLTYPE
DispatchAdapter::GetIDsOfNames( const IID & /*iid*/, OLECHAR ** /*names*/, UINT /*nameCount*/, LCID /*lcid*/, DISPID * out_dispId )
{
	MY_LOG("DispatchAdapter::GetIDsOfNames");
	*out_dispId = 0;
	return E_NOTIMPL;
}

//-------------------------------------
// function : DispatchAdapter::Invoke
// brief : invoke the method specified with ID
//-------------------------------------
HRESULT STDMETHODCALLTYPE
DispatchAdapter::Invoke( DISPID, const IID&, LCID, WORD, DISPPARAMS*, VARIANT*, EXCEPINFO*, UINT* )
{
	MY_LOG("DispatchAdapter::Invoke");
	return E_NOTIMPL;
}


/**********************************************************
Copyright (C) 2006-2009 YAMAMOTO Suguru

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
**********************************************************/
