// file: AccObj.h
// brief: Accessible object for SgRichEdit component
// author: SGRY (YAMAMOTO Suguru)
// update: 2007-04-24
// license: zlib License (see END of this file)
//=========================================================
#pragma once
#include <windows.h>
#include <stdio.h>
#include <oleacc.h> // MSAA
#include "SgRichEdit.h"

// FOR DEBUG
//#	include "Sgry.h"
//	using Sgry::LogFile;
//	using Sgry::LogOut;
	#define MY_LOG	
	//#define MY_LOG  LogFile
	//#define MY_LOG  LogFile
// FOR DEBUG


namespace SgRichEdit {

// accessible object for SgRichEdit
class AccObj : public IAccessible
{
	HWND _window;
	ULONG _refCount;
	IAccessible * _stdRichAccObj;
	IOleWindow * _oleWindowItf;

	// AccObj
	public:
		AccObj( HWND sgRichEdit );
		virtual ~AccObj();
		HWND GetWindow() const;

	// IUnknown
	public:
		virtual HRESULT STDMETHODCALLTYPE
			QueryInterface( const IID & iid, void ** out_objects );

		virtual ULONG STDMETHODCALLTYPE
			AddRef();

		virtual ULONG STDMETHODCALLTYPE
			Release();

	// IDispatch
	public:
        virtual HRESULT STDMETHODCALLTYPE
			GetTypeInfoCount( UINT * out_typeInfoCount );
        
        virtual HRESULT STDMETHODCALLTYPE
			GetTypeInfo( UINT typeInfoIndex, LCID lcid, ITypeInfo ** out_typeInfo );
        
        virtual HRESULT STDMETHODCALLTYPE
			GetIDsOfNames( const IID & iid, OLECHAR ** names, UINT nameCount, LCID lcid, DISPID * out_dispId );
        
        virtual HRESULT STDMETHODCALLTYPE
			Invoke( DISPID dispIdMember, const IID & iid, LCID lcid, WORD flags,
					DISPPARAMS * io_dispParams, VARIANT * out_result,
					EXCEPINFO * out_excepInfo, UINT * out_argErr
				);
        
	// IAccessible
	public:
		virtual HRESULT STDMETHODCALLTYPE
			get_accParent( IDispatch ** out_parentDispatchItf );

		virtual HRESULT STDMETHODCALLTYPE
			get_accChildCount( long * out_childrenCount );

		virtual HRESULT STDMETHODCALLTYPE
			get_accChild( VARIANT childId, IDispatch ** out_childDispItf );

		virtual HRESULT STDMETHODCALLTYPE
			get_accName( VARIANT child, BSTR * out_name );

		virtual HRESULT STDMETHODCALLTYPE
			get_accValue( VARIANT child, BSTR * out_value );

		virtual HRESULT STDMETHODCALLTYPE
			get_accDescription( VARIANT child, BSTR * out_description );

		virtual HRESULT STDMETHODCALLTYPE 
			get_accRole( VARIANT child, VARIANT * out_role );

		virtual HRESULT STDMETHODCALLTYPE 
			get_accState( VARIANT child, VARIANT * out_state );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			get_accHelp( VARIANT child, BSTR * out_help );
	    
		virtual HRESULT STDMETHODCALLTYPE
			get_accHelpTopic( BSTR * out_helpFile, VARIANT child, long * out_topicId );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			get_accKeyboardShortcut( VARIANT child, BSTR * out_keyboardShortcut );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			get_accFocus( VARIANT * out_id );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			get_accSelection( VARIANT * out_children );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			get_accDefaultAction( VARIANT child, BSTR * out_defaultAction );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			accSelect( long flagsSelect, VARIANT child );
	    
		virtual HRESULT STDMETHODCALLTYPE
			accLocation( long * out_x, long * out_y,
					long * out_width, long * out_height,
					VARIANT child
				);
	    
		virtual HRESULT STDMETHODCALLTYPE 
			accNavigate( long navDir, VARIANT start, VARIANT * out_end );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			accHitTest( long x, long y, VARIANT * out_child );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			accDoDefaultAction( VARIANT child );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			put_accName( VARIANT child, BSTR name );
	    
		virtual HRESULT STDMETHODCALLTYPE 
			put_accValue( VARIANT child, BSTR value );
};

} // namespace SgRichEdit

/**********************************************************
Copyright (C) 2006-2009 YAMAMOTO Suguru

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
**********************************************************/
