@echo off
setlocal

echo Compiling RedirectedProcess...

::---------------------------------------
:: check environment
::---------------------------------------

set _UPX_OK_=0
:: UPX.EXE exists?
(upx > NUL) 2> NUL
if not ERRORLEVEL == 9009  set _UPX_OK_=1

:: CL.EXE exists?
(cl > NUL) 2> NUL
if not ERRORLEVEL == 9009  goto build_vc

:: g++.exe exists?
(g++ > NUL) 2> NUL
if not ERRORLEVEL == 9009  goto build_gcc

echo no supported compiler was installed in this environment.
goto end


::---------------------------------------
:: compiling with Visual C++ / Platform SDK
::---------------------------------------
:build_vc
echo # using Visual C++
call build_vc.bat

goto end
::---------------------------------------
:: compiling with GNU C++ (MinGW)
::---------------------------------------
:build_gcc
echo # using GNU C++
call build_gcc.bat

:end
if  %_UPX_OK_% == 1 (
	upx -q -9 package\RedirectedProcess.dll
)
echo.
endlocal
